% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wlevels_subset.R
\name{subsetting_wlevels}
\alias{subsetting_wlevels}
\alias{[.wlevels}
\alias{[<-.wlevels}
\alias{[[<-.wlevels}
\title{Extraction Methods for a
'wlevels'-class Object}
\usage{
\method{[}{wlevels}(x, i, j, drop = if (missing(i)) TRUE else length(j) == 1)

\method{[}{wlevels}(x, i, j) <- value

\method{[[}{wlevels}(x, i, j) <- value
}
\arguments{
\item{x}{A 'wlevels'-class object.}

\item{i}{A numeric vector of row
number(s), a character vector of row
name(s), or a logical vector of
row(s) to be selected.}

\item{j}{A numeric vector of column
number(s), a character vector of
column name(s), or a logical vector
of column(s) to be selected.}

\item{drop}{Whether dropping a
dimension if it only have one
row/column.}

\item{value}{Ignored.}
}
\value{
A 'wlevels'-class object. See
\code{\link[=mod_levels]{mod_levels()}} and
\code{\link[=merge_mod_levels]{merge_mod_levels()}} for details on
this class.
}
\description{
For subsetting a
'wlevels'-class object. Attributes
related to the levels will be
preserved if appropriate.
}
\details{
Customized \code{[} for
'wlevels'-class objects, to ensure
that these operations work as they
would be on a data frame object,
while information specific to a
\code{wlevels}-class object modified
correctly.

The assignment methods \verb{[<-}
and \verb{[[<-} for
\code{wlevels}-class objects will raise an
error. This class of objects should
be created by \code{\link[=mod_levels]{mod_levels()}} or
related functions.

Subsetting the output of
\code{\link[=mod_levels]{mod_levels()}} is possible but not
recommended. It is more reliable to
generate the levels using
\code{\link[=mod_levels]{mod_levels()}} and related functions.
Nevertheless, there are situations in
which subsetting is preferred.
}
\examples{

data(data_med_mod_ab)
dat <- data_med_mod_ab
# Form the levels from a list of lm() outputs
lm_m <- lm(m ~ x*w1 + c1 + c2, dat)
lm_y <- lm(y ~ m*w2 + x + w1 + c1 + c2, dat)
lm_out <- lm2list(lm_m, lm_y)
w1_levels <- mod_levels(lm_out, w = "w1")
w1_levels
w1_levels[2, ]
w1_levels[c(2, 3), ]

dat <- data_med_mod_serial_cat
lm_m1 <- lm(m1 ~ x*w1 + c1 + c2, dat)
lm_y <- lm(y ~ m1 + x + w1 + c1 + c2, dat)
lm_out <- lm2list(lm_m1, lm_y)
w1gp_levels <- mod_levels(lm_out, w = "w1")
w1gp_levels
w1gp_levels[2, ]
w1gp_levels[3, ]

merged_levels <- merge_mod_levels(w1_levels, w1gp_levels)
merged_levels

merged_levels[4:6, ]
merged_levels[1:3, c(2, 3)]
merged_levels[c(1, 4, 7), 1, drop = FALSE]

}
\seealso{
\code{\link[=mod_levels]{mod_levels()}},
\code{\link[=mod_levels_list]{mod_levels_list()}}, and
\code{\link[=merge_mod_levels]{merge_mod_levels()}}
}
