% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maic_unanchored.R
\name{maic_unanchored}
\alias{maic_unanchored}
\title{Unanchored MAIC for binary and time-to-event endpoint}
\usage{
maic_unanchored(
  weights_object,
  ipd,
  pseudo_ipd,
  trt_ipd,
  trt_agd,
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  normalize_weights = FALSE,
  endpoint_type = "tte",
  endpoint_name = "Time to Event Endpoint",
  eff_measure = c("HR", "OR", "RR", "RD"),
  boot_ci_type = c("norm", "basic", "stud", "perc", "bca"),
  time_scale = "months",
  km_conf_type = "log-log",
  binary_robust_cov_type = "HC3"
)
}
\arguments{
\item{weights_object}{an object returned by \code{estimate_weight}}

\item{ipd}{a data frame that meet format requirements in 'Details', individual patient data (IPD) of internal trial}

\item{pseudo_ipd}{a data frame, pseudo IPD from digitized KM curve of external trial (for time-to-event endpoint) or
from contingency table (for binary endpoint)}

\item{trt_ipd}{a string, name of the interested investigation arm in internal trial \code{dat_igd} (real IPD)}

\item{trt_agd}{a string, name of the interested investigation arm in external trial \code{pseudo_ipd} (pseudo IPD)}

\item{trt_var_ipd}{a string, column name in \code{ipd} that contains the treatment assignment}

\item{trt_var_agd}{a string, column name in \code{ipd} that contains the treatment assignment}

\item{normalize_weights}{logical, default is \code{FALSE}. If \code{TRUE},
\code{scaled_weights} (normalized weights) in \code{weights_object$data} will be used.}

\item{endpoint_type}{a string, one out of the following "binary", "tte" (time to event)}

\item{endpoint_name}{a string, name of time to event endpoint, to be show in the last line of title}

\item{eff_measure}{a string, "RD" (risk difference), "OR" (odds ratio), "RR" (relative risk) for a binary endpoint;
"HR" for a time-to-event endpoint. By default is \code{NULL}, "OR" is used for binary case, otherwise "HR" is used.}

\item{boot_ci_type}{a string, one of \code{c("norm","basic", "stud", "perc", "bca")} to select the type of bootstrap
confidence interval. See \link[boot:boot.ci]{boot::boot.ci} for more details.}

\item{time_scale}{a string, time unit of median survival time, taking a value of 'years', 'months', 'weeks' or
'days'. NOTE: it is assumed that values in TIME column of \code{ipd} and \code{pseudo_ipd} is in the unit of days}

\item{km_conf_type}{a string, pass to \code{conf.type} of \code{survfit}}

\item{binary_robust_cov_type}{a string to pass to argument \code{type} of \link[sandwich:vcovHC]{sandwich::vcovHC}, see possible options in the
documentation of that function. Default is \code{"HC3"}}
}
\value{
A list, contains 'descriptive' and 'inferential'
}
\description{
This is a wrapper function to provide adjusted effect estimates and relevant statistics in unanchored case (i.e.
there is no common comparator arm in the internal and external trial).
}
\details{
For time-to-event analysis, it is required that input \code{ipd} and \code{pseudo_ipd} to have the following
columns. This function is not sensitive to upper or lower case of letters in column names.
\itemize{
\item USUBJID - character, unique subject ID
\item ARM - character or factor, treatment indicator, column name does not have to be 'ARM'. User specify in
\code{trt_var_ipd} and \code{trt_var_agd}
\item EVENT - numeric, 1 for censored/death, 0 for otherwise
\item TIME - numeric column, observation time of the \code{EVENT}; unit in days
}
}
\examples{
#
# unanchored example using maic_unanchored for time-to-event data
#
data(centered_ipd_sat)
data(adtte_sat)
data(pseudo_ipd_sat)

#### derive weights
weighted_data <- estimate_weights(
  data = centered_ipd_sat,
  centered_colnames = grep("_CENTERED$", names(centered_ipd_sat)),
  start_val = 0,
  method = "BFGS"
)

weighted_data2 <- estimate_weights(
  data = centered_ipd_sat,
  centered_colnames = grep("_CENTERED$", names(centered_ipd_sat)),
  start_val = 0,
  method = "BFGS",
  n_boot_iteration = 100,
  set_seed_boot = 1234
)

# inferential result
result <- maic_unanchored(
  weights_object = weighted_data,
  ipd = adtte_sat,
  pseudo_ipd = pseudo_ipd_sat,
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  trt_ipd = "A",
  trt_agd = "B",
  endpoint_name = "Overall Survival",
  endpoint_type = "tte",
  eff_measure = "HR",
  time_scale = "month",
  km_conf_type = "log-log"
)
result$descriptive$summary
result$inferential$summary

result_boot <- maic_unanchored(
  weights_object = weighted_data2,
  ipd = adtte_sat,
  pseudo_ipd = pseudo_ipd_sat,
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  trt_ipd = "A",
  trt_agd = "B",
  endpoint_name = "Overall Survival",
  endpoint_type = "tte",
  eff_measure = "HR",
  time_scale = "month",
  km_conf_type = "log-log"
)
result$descriptive$summary
result$inferential$summary
#
# unanchored example using maic_unanchored for binary outcome
#

data(centered_ipd_sat)
data(adrs_sat)

centered_ipd_sat
centered_colnames <- grep("_CENTERED$", colnames(centered_ipd_sat), value = TRUE)
weighted_data <- estimate_weights(data = centered_ipd_sat, centered_colnames = centered_colnames)
weighted_data2 <- estimate_weights(
  data = centered_ipd_sat, centered_colnames = centered_colnames,
  n_boot_iteration = 100
)

# get dummy binary IPD
pseudo_adrs <- get_pseudo_ipd_binary(
  binary_agd = data.frame(
    ARM = rep("B", 2),
    RESPONSE = c("YES", "NO"),
    COUNT = c(280, 120)
  ),
  format = "stacked"
)

# unanchored binary MAIC, with CI based on sandwich estimator
maic_unanchored(
  weights_object = weighted_data,
  ipd = adrs_sat,
  pseudo_ipd = pseudo_adrs,
  trt_ipd = "A",
  trt_agd = "B",
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  endpoint_type = "binary",
  endpoint_name = "Binary Endpoint",
  eff_measure = "RR",
  # binary specific args
  binary_robust_cov_type = "HC3"
)

# unanchored binary MAIC, with bootstrapped CI
maic_unanchored(
  weights_object = weighted_data2,
  ipd = adrs_sat,
  pseudo_ipd = pseudo_adrs,
  trt_ipd = "A",
  trt_agd = "B",
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  endpoint_type = "binary",
  endpoint_name = "Binary Endpoint",
  eff_measure = "RR",
  # binary specific args
  binary_robust_cov_type = "HC3"
)

#---------------------------------
}
