% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicalSystemModels.R
\name{ptransmodelODE}
\alias{ptransmodelODE}
\alias{ptransmodelDx}
\alias{ptransmodelDtheta}
\title{Protein transduction model}
\usage{
ptransmodelODE(theta, x, tvec)

ptransmodelDx(theta, x, tvec)

ptransmodelDtheta(theta, x, tvec)
}
\arguments{
\item{theta}{vector of parameters.}

\item{x}{matrix of system states (one per column) at the time points in \code{tvec}.}

\item{tvec}{vector of time points}
}
\value{
\code{ptransmodelODE} returns an array with the values of the derivatives \eqn{\dot{X}}.

\code{ptransmodelDx} returns a 3-D array with the values of the gradients with respect to \eqn{X}.

\code{ptransmodelDtheta} returns a 3-D array with the values of the gradients with respect to \eqn{\theta}.
}
\description{
The protein transduction equations model a biochemical reaction involving a signaling protein that degrades over time.  The system components \eqn{X = (S, S_d, R, S_R, R_{pp})} represent the levels of signaling protein, its degraded form, inactive state of \eqn{R}, \eqn{S-R} complex, and activated state of \eqn{R}.

\eqn{S}, \eqn{S_d}, \eqn{R}, \eqn{S_R} and \eqn{R_{pp}} are governed by the following differential equations:

\deqn{ \frac{dS}{dt} = -k_1 \cdot S -k_2 \cdot S \cdot R + k_3 \cdot S_R }
\deqn{ \frac{dS_d}{dt} = k_1 \cdot S  }
\deqn{ \frac{dR}{dt} = -k_2 \cdot S \cdot R + k_3 \cdot S_R + \frac{V \cdot R_{pp}}{K_m + R_{pp}} }
\deqn{ \frac{dS_R}{dt} = k_2 \cdot S \cdot R - k_3 \cdot S_R - k_4 \cdot S_R } 
\deqn{ \frac{dR_{pp}}{dt} = k_4 \cdot S_R - \frac{V \cdot R_{pp}}{K_m + R_{pp}}} 

where \eqn{\theta = (k_1, k_2, k_3,k_4, V, K_m)} are system parameters.
}
\examples{
theta <- c(0.07, 0.6, 0.05, 0.3, 0.017, 0.3)
x <- matrix(1:25, nrow = 5, ncol = 5)
tvec <- 1:5

ptransmodelODE(theta, x, tvec)

}
\references{
Vyshemirsky, V., & Girolami, M. A. (2008). Bayesian Ranking of Biochemical System Models. \emph{Bioinformatics}, 24(6), 833-839.
}
