% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{gpsmoothllik}
\alias{gpsmoothllik}
\title{Marginal log-likelihood for Gaussian process smoothing}
\usage{
gpsmoothllik(phisig, yobs, rInput, kerneltype = "generalMatern")
}
\arguments{
\item{phisig}{vector containing GP hyper-parameters phi and observation noise SD sigma. See \code{\link{calCov}} for the definitions of the hyper-parameters.}

\item{yobs}{vector of observations}

\item{rInput}{distance matrix between all time points of \code{yobs}}

\item{kerneltype}{the covariance kernel, types \code{matern}, \code{rbf}, \code{compact1}, \code{periodicMatern}, \code{generalMatern} are supported.  See \code{\link{calCov}} for their definitions.}
}
\value{
A list with elements \code{value} and \code{grad}, which are the log-likelihood value and gradient with respect to \code{phisig}, respectively.
}
\description{
Marginal log-likelihood and gradient as a function of GP hyper-parameters phi and observation noise standard deviation sigma. For use in Gaussian process smoothing where values of phi and sigma may be optimized.
}
\examples{
# Suppose phi[1] = 0.5, phi[2] = 3, sigma = 0.1
gpsmoothllik(c(0.5,3,0.1), rnorm(10), abs(outer(0:9, t(0:9),'-')[,1,]))

}
