% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.LPJmL_nc.R
\name{read.lpjml_nc}
\alias{read.lpjml_nc}
\title{Read LPJmL from nc-file}
\usage{
read.lpjml_nc(
  file_name,
  file_folder = "",
  years = NULL,
  split_data = FALSE,
  keep_month = FALSE,
  averaging_range = 1
)
}
\arguments{
\item{file_name}{file name including file ending (wildcards are supported).
Optionally also the full path can be specified here (instead of splitting it
to file\_name and file\_folder)}

\item{file_folder}{folder the file is located in (alternatively you can also
specify the full path in file\_name - wildcards are supported)}

\item{years}{a vector containing the years of interest}

\item{split_data}{split reading routine to avoid memory issues}

\item{keep_month}{keep monthly data (month as 3rd magpie data dim)}

\item{averaging_range}{number of years to be averaged (if even: overweight for prevous time period)}
}
\value{
\item{x}{MAgPIE-object}
}
\description{
Reads a LPJmL nc-file and converts it to a 3D array of the structure
(cells,years,datacolumn)
}
\examples{

\dontrun{
a <- read.lpjml_nc("sdate.nc")}

}
\seealso{
\code{"\linkS4class{magpie}"}, \code{\link{read.magpie}}
}
\author{
Kristine Karstens
}
