\name{magpie-class}
\docType{class}
\alias{magpie-class}
\alias{as.magpie}
\alias{as.magpie-methods}
\alias{as.magpie,magpie-method}
\alias{as.magpie,array-method}
\alias{as.magpie,lpj-method}
\alias{as.magpie,data.frame-method}
\alias{as.magpie,numeric-method}
\alias{as.magpie,NULL-method}
\alias{as.magpie,quitte-method}
\alias{is.magpie}
\alias{[,magpie-method}
\alias{[,magpie,ANY,ANY-method}
\alias{[<-,magpie,ANY,ANY-method}
\alias{[<-,magpie-method}
\alias{Ops,magpie,magpie-method}

\title{Class "magpie" ~~~ }
\description{The MAgPIE class is a data format for cellular MAgPIE data with a close relationship
to the array data format. \code{is.magpie} tests if \code{x} is an MAgPIE-object, \code{as.magpie}
transforms \code{x} to an MAgPIE-object (if possible). }
\usage{
is.magpie(x)
as.magpie(x,...)
}
\arguments{
  \item{x}{ An object that should be either tested or transformed as/to an MAgPIE-object. }
  \item{...}{additional arguments supplied for the conversion to a MAgPIE object. Allowed arguments for arrays and dataframes are \code{spatial} and \code{temporal} both expecting a vector of dimension or column numbers which contain the spatial or temporal information. By default both arguments are set to NULL which means that the \code{as.magpie} will try to detect automatically the temporal and spatial dimensions. The arguments will just overwrite the automatic detection. If you want to specify that the data does not contain a spatial or temporal dimension you can set the corresponding argument to 0. In addition \code{as.magpie} for data.frames is also expecting an argument called \code{datacol} which expects a number stating which is the first column containing data. This argument should be used if the dimensions are not detected corretly, e.g. if the last dimension column contains years which are then detected as values and therefore interpreted as first data column. In addition an argument \code{tidy=TRUE} can be used to indicate that the data.frame structure is following the rules of tidy data (last column is the data column all other columns contain dimension information). This information will help the conversion.}
}

\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("magpie", data, dim, dimnames, ...)}.
MAgPIE objects have three dimensions (cells,years,datatype) and the dimensionnames
of the first dimension have the structure "REGION.cellnumber".
MAgPIE-objects behave the same like array-objects with 2 exceptions: \cr
1.Dimensions of the object will not collapse (e.g. \code{x[1,1,1]} will remain 3D instead of becoming 1D)\cr
2.It is possible to extract full regions just by typing \code{x["REGIONNAME",,]}. \cr\cr

Please mind following standards: \cr
Header must not contain any purely numeric entries, but combinations of characters and numbers are allowed (e.g. "bla","12" is forbidden, wheras "bla","b12" is allowed)\cr
Years always have the structure "y" + 4-digit number, e.g. "y1995"\cr
Regions always have the structure 3 capital letters, e.g. "AFR" or "GLO"\cr\cr
This standards are necessary to allow the scripts to detect headers, years and regions properly and
to have a distinction to other data.
}
\section{Slots}{
	 \describe{
    \item{\code{.Data}:}{Object of class \code{"array"} ~~ }
  }
}
\section{Extends}{
Class \code{"\linkS4class{array}"}, from data part.
Class \code{"\linkS4class{structure}"}, by class "array", distance 2.
Class \code{"\linkS4class{matrix}"}, by class "array", distance 2, with explicit test and coerce.
Class \code{"\linkS4class{vector}"}, by class "array", distance 3, with explicit coerce.
Class \code{"\linkS4class{vector}"}, by class "array", distance 5, with explicit test and coerce.
}
\section{Methods}{
  \describe{
    \item{[}{\code{signature(x = "magpie")}: An extended []-syntax preventing the 
    collapsing of the array to less than 3 dimenions and allowing the direct access of regions by typing \code{x["REGIONNAME",,]}. In addition drop=TRUE will collapse the dimension within the 3 main categories, pmatch will allow for partial matches accessing the data (pmatch=TRUE will apply a general partial match, pmatch="left" will apply a partial match where the matching has to be at the beginning and for pmatch="right" the match has to be at the end of the string) and invert=TRUE will return the inverse subset of your query.}
    \item{Obs}{\code{signature(e1 = "magpie", e2 = "magpie")}: This method allows to use basic arithmetic calculations such as + or * with MAgPIE objects.}
	 }
}
\author{ Jan Philipp Dietrich }

\seealso{
	\code{\link{read.magpie}}, \code{\link{write.magpie}}, \code{\link{getRegions}}, \code{\link{getYears}}, \code{\link{getNames}}, 
  \code{\link{getCPR}}, \code{\link{ncells}}, \code{\link{nyears}}, \code{\link{ndata}} 
}
\examples{
showClass("magpie")

data(population_magpie)

# returning PAO and PAS for 2025
population_magpie["PA",2025,,pmatch="left"]

# returning CPA for 2025
population_magpie["PA",2025,,pmatch="right"]

# returning CPA PAO and PAS for 2025
population_magpie["PA",2025,,pmatch=TRUE]

# returning PAS and 2025
population_magpie["PAS",2025,]

# returning everything but values for PAS or values for 2025
population_magpie["PAS",2025,,invert=TRUE]


}
\keyword{classes}
