% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_maestro.R
\name{create_maestro}
\alias{create_maestro}
\title{Creates a new maestro project}
\usage{
create_maestro(path, type = "R", overwrite = FALSE, quiet = FALSE, ...)
}
\arguments{
\item{path}{file path for the orchestrator script}

\item{type}{file type for the orchestrator (supports R, Quarto, and RMarkdown)}

\item{overwrite}{whether to overwrite an existing orchestrator or maestro project}

\item{quiet}{whether to silence messages in the console (default = \code{FALSE})}

\item{...}{unused}
}
\value{
invisible
}
\description{
Creates a new maestro project
}
\examples{

# Creates a new maestro project with an R orchestrator
new_proj_dir <- tempdir()
create_maestro(new_proj_dir, type = "R", overwrite = TRUE)

create_maestro(new_proj_dir, type = "Quarto", overwrite = TRUE)
}
