% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-data_summarise.R
\name{dataset_summarize}
\alias{dataset_summarize}
\title{Generate an assessment report and summary of a dataset}
\usage{
dataset_summarize(
  dataset,
  data_dict = data_dict_extract(dataset),
  group_by = NULL,
  taxonomy = NULL,
  dataset_name = .dataset_name,
  valueType_guess = FALSE,
  .dataset_name = NULL
)
}
\arguments{
\item{dataset}{A dataset object.}

\item{data_dict}{A list of data frame(s) representing metadata of the input
dataset. Automatically generated if not provided.}

\item{group_by}{A character string identifying the column in the dataset
to use as a grouping variable. Elements will be grouped by this
column.}

\item{taxonomy}{An optional data frame identifying a variable classification
schema.}

\item{dataset_name}{A character string specifying the name of the dataset
(internally used in the function \code{\link[=dossier_evaluate]{dossier_evaluate()}}).}

\item{valueType_guess}{Whether the output should include a more accurate
valueType that could be applied to the dataset. FALSE by default.}

\item{.dataset_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
A list of data frames containing assessment reports and summaries.
}
\description{
Assesses and summarizes the content and structure of a dataset and generates
reports of the results. This function can be used to evaluate data structure,
presence of specific fields, coherence across elements, and data dictionary
formats, and to summarize additional information about variable distributions
and descriptive statistics.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.

A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal/}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.

The valueType is a declared property of a variable that is required in
certain functions to determine handling of the variables. Specifically,
valueType refers to the
\href{https://opaldoc.obiba.org/en/dev/variables-data.html#value-types}{OBiBa data type of a variable}.
The valueType is specified in a data dictionary in a column 'valueType' and
can be associated with variables as attributes. Acceptable valueTypes
include 'text', 'integer', 'decimal', 'boolean', datetime', 'date'. The full
list of OBiBa valueType possibilities and their correspondence with R data
types are available using \link{valueType_list}. The valueType can be used to
coerce the variable to the corresponding data type.
}
\examples{
{

# use madshapR_DEMO provided by the package
library(dplyr)

#' ###### Example : Any data frame can be summarized
dataset <- iris['Sepal.Width']
glimpse(dataset_summarize(dataset))
 
}

}
\seealso{
\code{\link[=dossier_evaluate]{dossier_evaluate()}}
}
