% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{is_data_dict_shape}
\alias{is_data_dict_shape}
\title{Test if an object is a workable data dictionary structure}
\usage{
is_data_dict_shape(object)
}
\arguments{
\item{object}{A potential data dictionary structure to be evaluated.}
}
\value{
A logical.
}
\description{
Tests if the input object has adequate structure to work with functions
involving data dictionary shaping. This function mainly helps validate input
within other functions of the package but could be used to check if an
object is valid for use in a function.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package

data_dict <- DEMO_files$dd_MELBOURNE_1_format_maelstrom
is_data_dict_shape(data_dict)
is_data_dict_shape(iris)

}

}
\seealso{
For a better assessment, please use \code{\link[=data_dict_evaluate]{data_dict_evaluate()}}.
}
