% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_macrosynteny.R
\name{plot_macrosynteny}
\alias{plot_macrosynteny}
\title{Plot Macro-synteny}
\usage{
plot_macrosynteny(macrosynt_df, sp1_label = "", sp2_label = "")
}
\arguments{
\item{macrosynt_df}{dataframe of contingency table with p-values calculated by the compute_macrosynteny() function}

\item{sp1_label}{character. The name of the species1 to display on the plot}

\item{sp2_label}{character. The name of the species2 to put on the plot}
}
\value{
ggplot2 object
}
\description{
This is a function to generate the contingency table of an MBH dataframe and apply fischer test to calculate the significant associations.
}
\examples{
# basic usage of plot_macrosynteny : 

orthologs_table <- system.file("extdata","my_orthologs.tab",package="macrosyntR")

my_orthologs <- read.table(orthologs_table,header=TRUE)
                               
my_macrosynteny <- compute_macrosynteny(my_orthologs)

plot_macrosynteny(my_macrosynteny,
                  sp1_label = "B.floridae",
                  sp2_label = "P.echinospica")

}
\seealso{
\code{\link[=compute_macrosynteny]{compute_macrosynteny()}}
}
