% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/made.r
\name{madem.copula}
\alias{madem.copula}
\title{Minimum Approximate Distance Estimate of Copula with given model degrees}
\usage{
madem.copula(u, m)
}
\arguments{
\item{u}{an \code{n x d} matrix of (pseudo) observations.}

\item{m}{\code{d}-vector of model degrees}
}
\value{
An invisible \code{mable} object with components
\itemize{
  \item \code{m} the given degree
  \item \code{p} the estimated vector of mixture proportions 
     \eqn{p = (p_0, \ldots, p_m)}
      with the given degree \code{m}
  \item \code{D}  the minimum distance at degree \code{m}
 }
}
\description{
Minimum Approximate Distance Estimate of Copula with given model degrees
}
\details{
With given model degrees \code{m}, the parameters \code{p}, the mixing
  proportions of the beta distribution, are calculated as the minimizer of the
  approximate \eqn{L_2} distance between the empirical distribution and 
  the Bernstein polynomial model.
}
