% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{replace}
\alias{replace}
\title{Change contents of an existing variable}
\usage{
replace(data, var, value, ...)
}
\arguments{
\item{data}{Dataset}

\item{var}{Variable}

\item{value}{Replacement value}

\item{...}{\code{if} conditions.}
}
\value{
Modified Dataset
}
\description{
\code{replace()} alters the values of a variable when specified
conditions are met.

\preformatted{replace(data, var, value,
     var < somevalue | var > somevalue, is.na(var))}

If conditions are not specified, \code{replac()} changes the whole
variable with specified value.

\preformatted{replace(data, var, value)}
}
\details{
It is used when multiple conditions have to be met to change a value.
The function first checks whether specified value is a variable of the dataset.
If yes, then the values are replaced with those of that variables
with the conditions.
}
\examples{

## use infert dataset
data(infert)

## replace parity == NA if parity > 4
tab(infert, parity)

infert.new <- replace(infert, parity, NA, parity > 4)
tab(infert.new, parity)

## replace education as character
infert.new <- replace(infert, education, as.character(education))
codebook(infert.new)
tab(infert.new, education)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
