% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelVar.R
\name{labelVar}
\alias{labelVar}
\alias{labelData}
\title{Add or replace labels of variables and dataset}
\usage{
labelVar(data, var, lbl = NULL)

labelData(data, lbl = NULL)
}
\arguments{
\item{data}{dataset}

\item{var}{one variable or variables}

\item{lbl}{to specify labels. If not specified, label is removed}
}
\description{
\code{labelVar} labels \code{variables}.

\code{labelData} labels \code{Dataset}.
}
\details{
Labels are useful to provide more detailed information about
variables or dataset. Many functions in \code{mStats} package
extract label information and display them as footnote.

\strong{Label single or multiple variables}

Single or multiple variables can be labelled.

Example: single variable

\preformatted{labelVar(data, var, lbl)}

Example: multiple variable

\preformatted{labelVar(data,
      c(var1, var2, var3),
      c(lbl1, lbl2, lbl3))}

\strong{Label Dataset}

Dataset can also be labelled and displayed in \code{codebook}.

\preformatted{labelData(data, lbl)}
}
\examples{

## use infert data
data(infert)

## label education
infert.new <- labelVar(infert, education, "patient's education")
codebook(infert.new)

## label multiple variables
infert.new <- labelVar(infert, c(education, age, case),
                       c("patient's education", "age in years", "case status"))
codebook(infert.new)


## label dataset
infert.new <- labelData(infert.new,
                        "Infertility after Spontaneous and Induced Abortion")
codebook(infert.new)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
