% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-args-expunge.R
\name{check_args_expunge}
\alias{check_args_expunge}
\title{Expunge Message Arguments Check}
\usage{
check_args_expunge(imapconf, specific_UID, retries)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{specific_UID}{A numeric vector containing one or more messages UIDs, if
specific messages should be expunged and not the whole mailbox.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
\code{NULL} if arguments are correct.
}
\description{
Internal helper function for checking the arguments
    used in \link{expunge} function.
}
\seealso{
Other miscellaneous helper: \code{\link{check_args_add_replace_flags}},
  \code{\link{check_args_copy_msg}},
  \code{\link{check_args_delete_msg}},
  \code{\link{check_args_get_max_min_id}}

Other check args: \code{\link{check_args_add_replace_flags}},
  \code{\link{check_args_copy_msg}},
  \code{\link{check_args_custom_search}},
  \code{\link{check_args_delete_msg}},
  \code{\link{check_args_fetch_full_msg}},
  \code{\link{check_args_fetch_msg_header}},
  \code{\link{check_args_fetch_msg_metadata}},
  \code{\link{check_args_fetch_msg_text}},
  \code{\link{check_args_get_attachments}},
  \code{\link{check_args_get_max_min_id}},
  \code{\link{check_args_move_msg}},
  \code{\link{check_args_remove_flags}},
  \code{\link{check_args_search_date}},
  \code{\link{check_args_search_flag}},
  \code{\link{check_args_search_period}},
  \code{\link{check_args_search_size}},
  \code{\link{check_args_search_string}},
  \code{\link{check_args_search_within}}
}
\concept{check args}
\concept{miscellaneous helper}
\keyword{internal}
