#' @inherit before
#'
#' @family customsearch helper functions
#'
#' @examples
#'
#' \dontrun{
#'
#' # configure IMAP
#' library(mRpostman)
#' imapconf <- configure_imap(url="imaps://your.imap.server.com",
#'                            username="your_username",
#'                            password=rstudioapi::askForPassword()
#'                           )
#'
#' # search
#' result <- imapconf %>%
#'     select_mailbox(mbox = "INBOX") %>%
#'     custom_search(custom_request = OR(on(date_char = "17-Apr-2019"),
#'                                       on(date_char = "17-Jul-2018")))
#' # searches for messages On "17-Apr-2019" OR On "17-Jul-2018".
#'
#' }
#'
#' @export
#'
on <- function(date_char, negate = FALSE) {


  check_args_date(date_char, negate)

  # setting part of the search string

  if (!isTRUE(negate)) {
    out = paste0('(ON ', date_char, ')')

  } else {
    out = paste0('(NOT (ON ', date_char, '))')

  }

  return(out)

}
