% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-server-capabilities.R
\name{list_server_capabilities}
\alias{list_server_capabilities}
\title{IMAP Server Capabilities}
\usage{
list_server_capabilities(imapconf, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
A character \code{vector} containing server's IMAP capacbilities.
}
\description{
Lists IMAP server's capabilities.
}
\examples{
\dontrun{

# configure IMAP
#' library(mRpostman)
imapconf <- configureIMAP(url="imaps://imap.gmail.com",
                          username="your_gmail_user",
                          password=rstudioapi::askForPassword()
                         )

# list server's capabilities
results <- imapconf \%>\%
  list_server_capabilities()

}

}
\seealso{
Other mailbox commands: \code{\link{examine_mailbox}},
  \code{\link{list_mailboxes}},
  \code{\link{rename_mailbox}},
  \code{\link{select_mailbox}}
}
\concept{mailbox commands}
