% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expunge.R
\name{expunge}
\alias{expunge}
\title{Expunge Messages}
\usage{
expunge(imapconf, specific_UID = NULL, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{specific_UID}{A numeric vector containing one or more messages UIDs, if
specific messages should be expunged and not the whole mailbox.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
The (invisible) imapconf object that was previously inputed.
}
\description{
Expunge a specific message (using specific UID) or all messages
    marked as "DELETED" in a mailbox.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://imap.gmail.com",
                           username="your_gmail_user",
                           password=rstudioapi::askForPassword()
                          )

# deleting a message using specific UID
result1 <- imapconf \%>\%
    select_mailbox(mbox = "TAM") \%>\%
    delete_msg(msg_id = 71171, by = "UID") \%$\%
    expunge(imapconf = imapconf, specific_UID = msg_id)


# expunge all message smarked as "DELETED" in INBOX
result2 <- imapconf \%>\%
    select_mailbox(mbox = "INBOX") \%>\%
    expunge()

}

}
\seealso{
Other miscellaneous: \code{\link{add_flags}},
  \code{\link{copy_msg}}, \code{\link{count_msgs}},
  \code{\link{delete_msg}}, \code{\link{get_max_id}},
  \code{\link{get_min_id}}, \code{\link{move_msg}},
  \code{\link{remove_flags}}, \code{\link{replace_flags}}
}
\concept{miscellaneous}
