% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-args-copy-msg.R
\name{check_args_copy_msg}
\alias{check_args_copy_msg}
\title{Copy Message Arguments Check}
\usage{
check_args_copy_msg(imapconf, msg_id, by, to_mbox, reselect_mbox, retries)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{msg_id}{A numeric vetor containing one or more messages ids.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{to_mbox}{A character string specifying the mailbox to which messages
will be copied to.}

\item{reselect_mbox}{If \code{TRUE}, calls \code{select_mailbox(mbox = to_mbox)}
before returning the output. Default is \code{FALSE} for moving and
copying operations, whereas it is \code{TRUE} for renaming mailboxes.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
\code{NULL} if arguments are correct.
}
\description{
Internal helper function for checking the arguments
    used in \link{copy_msg} function.
}
\seealso{
Other miscellaneous helper: \code{\link{check_args_add_replace_flags}},
  \code{\link{check_args_delete_msg}},
  \code{\link{check_args_expunge}},
  \code{\link{check_args_get_max_min_id}}

Other check args: \code{\link{check_args_add_replace_flags}},
  \code{\link{check_args_custom_search}},
  \code{\link{check_args_delete_msg}},
  \code{\link{check_args_expunge}},
  \code{\link{check_args_fetch_full_msg}},
  \code{\link{check_args_fetch_msg_header}},
  \code{\link{check_args_fetch_msg_metadata}},
  \code{\link{check_args_fetch_msg_text}},
  \code{\link{check_args_get_max_min_id}},
  \code{\link{check_args_move_msg}},
  \code{\link{check_args_remove_flags}},
  \code{\link{check_args_search_date}},
  \code{\link{check_args_search_flag}},
  \code{\link{check_args_search_period}},
  \code{\link{check_args_search_size}},
  \code{\link{check_args_search_string}},
  \code{\link{check_args_search_within}}
}
\concept{check args}
\concept{miscellaneous helper}
\keyword{internal}
