% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDynamicFollNet.R
\name{getDynamicFollNet}
\alias{getDynamicFollNet}
\title{getDynamicFollNet function}
\usage{
getDynamicFollNet(
  TS,
  timeWindow,
  timeShift,
  sigma = 0.5,
  lagWindow = 0.1,
  silentFlag = FALSE
)
}
\arguments{
\item{TS}{is a set of time series where \code{TS[i,t,d]} is a numeric value of \code{i}th time series at time \code{t} and dimension \code{d}.}

\item{timeWindow}{is a time window parameter that limits a length of each sliding window. The default is 10 percent of time series length.}

\item{timeShift}{is a number of time steps a sliding window shifts from a previous window to the next one. The default is 10 percent of \code{timeWindow}.}

\item{sigma}{is a threshold of following relation. The default is 0.5.}

\item{lagWindow}{is a maximum possible time delay in the term of percentage of time length of \code{timeWindow} supplying to the followingNetwork function.}

\item{silentFlag}{is a flag that prohibit the function to print the current status of process.}
}
\value{
This function returns adjacency matrices of a dynamic following network of \code{TS} as well as the corresponding time series of network densities.

\item{dyNetWeightedMat}{ An adjacency matrix of a dynamic following network
s.t. if \code{dyNetWeightedMat[i,j,t]>0}, then \code{TS[i,,]} follows  \code{TS[j,,]} at time \code{t} with a degree \code{dyNetWeightedMat[i,j,t]}. }
\item{dyNetBinMat}{ A binary version of \code{dyNetWeightedMat} s.t. \code{dyNetWeightedMat[i,j,t] <- (dyNetWeightedMat[i,j,t] >=sigma)} for any \code{i,j,t}.  }
\item{dyNetWeightedDensityVec}{A time series of dynamic network densities of \code{dyNetWeightedMat}}
\item{dyNetBinDensityVec}{A time series of dynamic network densities of \code{dyNetBinDensityVec}}
}
\description{
getDynamicFollNet is a support function for calculating a dynamic following network of a set of time series
}
\examples{

# Run the function
out<-getDynamicFollNet(TS=mFLICA::TS[,1:10,],timeWindow=5,timeShift = 5,sigma=0.5)

}
