% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xytb-class.R
\name{modelRF}
\alias{modelRF}
\title{xytb randomForest function}
\usage{
modelRF(xytb, type = c("actual", "shifted"), nob = "-1", colin = TRUE,
  varkeep = c("v", "dist", "thetarel"), zerovar = TRUE, rfcv = FALSE,
  ntree = 501, importance = TRUE, ...)
}
\arguments{
\item{xytb}{an xytb object}

\item{type}{character -actual or shifted- use actual data or shifted one to
build the model}

\item{nob}{character. Define the unobserved value of the behaviour (and
where prediction are done)}

\item{colin}{boolean - remove colinearity among predictors (see the caret
package for more details)}

\item{varkeep}{character vector - the variables names in this vector are
keeped in the model even if colinearity is found (usefull to keep 'classical'
parameters and to help interpretation)}

\item{zerovar}{boolean - remove near zero variance predictor (see the caret
package for more details)}

\item{rfcv}{boolean - run a random forest cross-validation for feature selection
procedure for xybt (this call the \code{rfcv} fonction for the model).
This function shows the cross-validated prediction performance of models 
with sequentially reduced number of predictors (ranked by variable
importance) via a nested cross-validation procedure for a xytb object.}

\item{ntree}{number of trees in the random Forest (see the randomForest
package for more details)}

\item{importance}{boolean (see the randomForest package for more details)}

\item{...}{other arguements passed to randonForest or rfcv}
}
\description{
Build a random forest model on a xytb object, predicting behaviour using
only the variables calculated at the time of observation (type `actual`) or
using the variable shifted backwards in time (type `shifted`). Parameters
are transfered to the randomForest or the rfcv functions of the randomForest
package if needed.
}
\examples{
#track_CAGA_005 is dataset
#generate a complete xytb object with derived (over moving windows of 3, 5
#and 9 points, with quantile at 0, 50 and 100\%) and shifted information on 10
#and 100 points
xytb<-xytb(track_CAGA_005,"a track",c(3,5,9),c(0,.5,1),c(10,100))
#compute a random forest model to predict behaviour (b, where -1 is
#unobserved behaviour) using the derived
#parameters ("actual")
xytb<-modelRF(xytb,"actual",nob="-1",colin=TRUE,varkeep=c("v","thetarel"),
zerovar=TRUE)
\dontrun{ 
#cross-validation for the same model (time consuming !)
xytb<-modelRF(xytb,"actual",nob="-1",colin=TRUE,varkeep=c("v","thetarel"),
zerovar=TRUE,rfcv=TRUE)
}


}
\seealso{
See \link[randomForest]{randomForest} and \link[randomForest]{rfcv}
}
\author{
Laurent Dubroca and Andréa Thiebault
}
