% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lvec.R
\name{lvec}
\alias{lvec}
\title{Create memory mapped vector}
\usage{
lvec(
  size,
  type = c("numeric", "integer", "logical", "character"),
  strlen = NULL
)
}
\arguments{
\item{size}{the size of the vector}

\item{type}{the type of the vector. Should be one of the following value: 
\code{"numeric"}, \code{"integer"}, \code{"logical"} or \code{"character"}. 
The types will create vectors corresponding to the corresponding R types.}

\item{strlen}{in case of a vector of type \code{"character"} the maximum
length of the strings should also be specified using \code{strlen}.}
}
\value{
Returns an object of type \code{lvec}. Elements of this vector are stored on
file (partially buffered in memory for speed) allowing one to work with more
data than fits into memory.
}
\description{
The data in these vectors are stored on disk (partially buffered for speed)
allowing one to work with more data than fits into available memory.
}
\details{
The minimum value of \code{strlen} is two. When a value smaller than that is
given it is automatically set to two. This is because a minimum of two bytes
is necessary to also store missing values correctly.
}
\examples{
# create an integer vector of length 100
x <- lvec(100, type = "integer")
# Get the first 10 values; values are initialised to 0 by default
lget(x, 1:10)
# Set the first 10 values to 11:20
lset(x, 1:10, 11:20)

# set maximum length of the string to 1, strings longer than that get
# truncated. However, minimum value of strlen is 2. 
x <- lvec(10, type = "character", strlen = 1)
lset(x, 1:3, c("a", "foo", NA))
lget(x, 1:3)

}
