% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.lsm.R
\name{summary.lsm}
\alias{summary.lsm}
\title{Summarizing  Method for \code{lsm}  Objects}
\usage{
\method{summary}{lsm}(object, ...)
}
\arguments{
\item{object}{An expression of the form y ~ model, where y is the outcome variable (binary or dichotomous: its values are 0 or 1).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class "\code{lsm}" is a list containing at least the
 following components:

\item{object}{a \code{lsm} object}
\item{\dots}{Additional arguments to be passed to methods.}
}
\description{
Provides a \code{summary} method for \code{lsm}  objects.
}
\details{
summary Method for lsm

The saturated model is characterized by the assumptions 1 and 2 presented in section 2.3 by Llinas (2006, ISSN:2389-8976).
}
\examples{
 #Hosmer, D. (2013) page 3: Age and coranary Heart Disease (CHD) Status of 20 subjects:
 #AGE <- c(20, 23, 24, 25, 25, 26, 26, 28, 28, 29, 30, 30, 30, 30, 30, 30, 30, 32, 33, 33)
 #CHD <- c(0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0)
 # data <- data.frame (CHD, AGE)
 # Ela <- lsm(CHD ~ AGE, family = binomial, data)
 # summary(Ela)
}
\references{
[1] LLinás, H. J. (2006). Precisiones en la teoría de los modelos logísticos. Revista Colombiana de Estadística, 29(2), 239–265. https://revistas.unal.edu.co/index.php/estad/article/view/29310

[2] Hosmer, D.W., Lemeshow, S. and Sturdivant, R.X. (2013). Applied Logistic Regression, 3rd ed., New York: Wiley.

[3] Chambers, J. M. and Hastie, T. J. (1992). Statistical Models in S. Wadsworth & Brooks/Cole.
}
\author{
Jorge Villalba Acevedo [cre, aut], (Universidad Tecnológica de Bolívar, Cartagena-Colombia).
}
