% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switching_series.R
\name{switching_series}
\alias{switching_series}
\title{Compute values of transition function to separate regimes}
\usage{
switching_series(switching_data, specs)
}
\arguments{
\item{switching_data}{A numeric vector.}

\item{specs}{A \link{list}() with inputs as in \link{lp_nl}().}
}
\value{
\item{fz}{A numeric vector with values from smooth transition function \eqn{F(z_{t-1})}.}
}
\description{
Function to estimate transition values, which uses a smooth transition function as
used in Auerbach and Gorodnichenko (2012). The time series used in the transition function
can be de-trended via the Hodrick-Prescott (see Auerbach and Gorodnichenko, 2013).
}
\references{
Auerbach, A. J., and  Gorodnichenko Y. (2012). "Measuring the Output Responses to Fiscal Policy."
\emph{American Economic Journal: Economic Policy}, 4 (2): 1-27.

Auerbach, A. J., and Gorodnichenko Y. (2013). "Fiscal Multipliers in Recession and Expansion."
\emph{NBER Working Paper Series}. Nr 17447.
}
\author{
Philipp Adämmer
}
