% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{measures1d}
\alias{measures1d}
\title{Closure of One Dimensional Measures}
\usage{
measures1d(data, ...)
}
\arguments{
\item{data}{a data.frame with the data used to calculate the measures}

\item{...}{named arguments, name is the function name and argument is the 
function to calculate the measure for each variable.}
}
\value{
a measures object
}
\description{
Function creates a 1d measures object that can be used with 
  \code{\link{l_ng_plots}} and \code{\link{l_ng_ranges}}.
}
\details{
For more information run: \code{l_help("learn_R_display_graph.html#measures")}
}
\examples{
m1 <- measures1d(oliveAcids, mean=mean, median=median,
     sd=sd, q1=function(x)as.vector(quantile(x, probs=0.25)),
     q3=function(x)as.vector(quantile(x, probs=0.75)))
     
m1
m1()
m1(olive$palmitoleic>100)
m1('data')
m1('measures')
}
\seealso{
\code{\link{l_ng_plots}}, \code{\link{l_ng_ranges}},
  \code{\link{measures2d}}
}
