% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loonGrob.R, R/loonGrob_l_compound.R,
%   R/loonGrob_l_layer_graph.R, R/loonGrob_l_layer_histogram.R,
%   R/loonGrob_l_layer_scatterplot.R, R/loonGrob_l_navgraph.R,
%   R/loonGrob_l_navigator.R, R/loonGrob_l_serialaxes.R
\name{loonGrob}
\alias{loonGrob}
\alias{loonGrob.l_compound}
\alias{loonGrob.l_layer_graph}
\alias{loonGrob.l_layer_histogram}
\alias{loonGrob.l_layer_scatterplot}
\alias{loonGrob.l_navgraph}
\alias{loonGrob.l_navigator}
\alias{loonGrob.l_serialaxes}
\title{Create a grid grob from a loon widget handle}
\usage{
loonGrob(target, name = NULL, gp = NULL, vp = NULL)

\method{loonGrob}{l_compound}(target, name = NULL, gp = NULL,
  vp = NULL)

\method{loonGrob}{l_layer_graph}(target, name = NULL, gp = NULL,
  vp = NULL)

\method{loonGrob}{l_layer_histogram}(target, name = NULL, gp = NULL,
  vp = NULL)

\method{loonGrob}{l_layer_scatterplot}(target, name = NULL, gp = NULL,
  vp = NULL)

\method{loonGrob}{l_navgraph}(target, name = NULL, gp = NULL,
  vp = NULL)

\method{loonGrob}{l_navigator}(target, name = NULL, gp = NULL,
  vp = NULL)

\method{loonGrob}{l_serialaxes}(target, name = NULL, gp = NULL,
  vp = NULL)
}
\arguments{
\item{target}{either an object of class loon or a vector that specifies the
widget, layer, glyph, navigator or context completely. The widget is
specified by the widget path name (e.g. \code{'.l0.plot'}), the remaining
objects by their ids.}

\item{name}{a character identifier for the grob, or NULL. Used to find the grob on the display list
and/or as a child of another grob.}

\item{gp}{a gpar object, or NULL, typically the output from a call to the function gpar. 
This is basically a list of graphical parameter settings.}

\item{vp}{a grid viewport object (or NULL).}
}
\value{
a grid grob
}
\description{
Grid grobs are useful to create publication quality graphics.
}
\examples{

widget <- with(iris, l_plot(Sepal.Length, Sepal.Width))

lgrob <- loonGrob(widget)

library(grid)
grid.ls(lgrob, viewports=TRUE, fullNames=TRUE)
grid.newpage(); grid.draw(lgrob)

\dontrun{
p <- demo("l_layers", ask = FALSE)$value

lgrob <- loonGrob(p)
grid.newpage(); grid.draw(lgrob)

p <- demo("l_glyph_sizes", ask = FALSE)$value

lgrob <- loonGrob(p)
grid.newpage()
grid.draw(lgrob)
}

 
\dontrun{

library(grid)
## l_pairs (scatterplot matrix) examples

p <- l_pairs(iris[,-5], color=iris$Species)

lgrob <- loonGrob(p)
grid.newpage()
grid.draw(lgrob)

## Time series decomposition examples

decompose <- decompose(co2) 
# or decompose <- stl(co2, "per")
p <- l_plot(decompose, title = "Atmospheric carbon dioxide over Mauna Loa")

lgrob <- loonGrob(p)
grid.newpage()
grid.draw(lgrob)
}


\dontrun{
## graph examples

G <- completegraph(names(iris[,-5]))
LG <- linegraph(G)
g <- l_graph(LG)

nav0 <- l_navigator_add(g)
l_configure(nav0, label = 0)
con0 <- l_context_add_geodesic2d(navigator=nav0, data=iris[,-5])

nav1 <- l_navigator_add(g, from = "Sepal.Length:Petal.Width", 
  to = "Petal.Length:Petal.Width", proportion = 0.6)
l_configure(nav1, label = 1)
con1 <- l_context_add_geodesic2d(navigator=nav1, data=iris[,-5])

nav2 <- l_navigator_add(g, from = "Sepal.Length:Petal.Length", 
  to = "Sepal.Width:Petal.Length", proportion = 0.5)
l_configure(nav2, label = 2)
con2 <- l_context_add_geodesic2d(navigator=nav2, data=iris[,-5])

library(grid)
lgrob <- loonGrob(g)
grid.newpage(); grid.draw(lgrob)
}


\dontrun{
## histogram examples

h <- l_hist(iris$Sepal.Length, color=iris$Species)

g <- loonGrob(h)

library(grid)
grid.newpage(); grid.draw(g)

h['showStackedColors'] <- TRUE

g <- loonGrob(h)

grid.newpage(); grid.draw(g)

h['colorStackingOrder'] <- c("selected", unique(h['color']))

g <- loonGrob(h)
grid.newpage(); grid.draw(g)


h['colorStackingOrder'] <- rev(h['colorStackingOrder'])

g <- loonGrob(h)
grid.newpage(); grid.draw(g)
}


## l_plot scatterplot examples

p <- l_plot(x = c(0,1), y = c(0,1))
l_layer_rectangle(p, x = c(0,1), y = c(0,1))

g <- loonGrob(p) 

library(grid)
grid.newpage(); grid.draw(g)

p['glyph'] <- "ctriangle"
p['color'] <- "blue"
p['size'] <- c(10, 20)
p['selected'] <- c(TRUE, FALSE)
g <- loonGrob(p)
grid.newpage(); grid.draw(g)


\dontrun{
## navgraph examples

ng <- l_navgraph(oliveAcids, separator='-', color=olive$Area)

library(grid)
navGrob <- loonGrob(ng)
grid.newpage()
grid.draw(navGrob)
}


## Serial axes (radial and parallel coordinate) examples

s <- l_serialaxes(data=oliveAcids, color=olive$Area, title="olive data")
s['axesLayout'] <- 'parallel'

library(grid)
grid.newpage(); grid.loon(s)

}
\seealso{
\code{\link{grid.loon}}
}
