% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_raise}
\alias{l_layer_raise}
\title{Switch the layer place with its sibling to the left}
\usage{
l_layer_raise(widget, layer)
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
0 if success otherwise the function throws an error
}
\description{
Change the layers position within its parent layer group by 
  decreasing the \code{index} of the layer by one if possible. This means 
  that the raised layer will be rendered after (or on top) of its sibling
  layer to the left.
}
\examples{
p <- l_plot()

l1 <- l_layer_rectangle(p, x=0:1, y=0:1)
l2 <- l_layer_oval(p, x=0:1, y=0:1, color='thistle')

l_aspect(p) <- 1

l_layer_raise(p, l1)
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_layer_lower}}, \code{\link{l_layer_move}}
}
