% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric.R
\name{nll_elife}
\alias{nll_elife}
\title{Likelihood for arbitrary censored and truncated data}
\usage{
nll_elife(
  par,
  time,
  time2 = NULL,
  event = NULL,
  type = c("right", "left", "interval", "interval2"),
  ltrunc = NULL,
  rtrunc = NULL,
  family = c("exp", "gp", "gomp", "gompmake", "weibull", "extgp", "gppiece",
    "extweibull", "perks", "beard", "perksmake", "beardmake"),
  thresh = 0,
  weights = NULL,
  status = NULL,
  arguments = NULL,
  ...
)
}
\arguments{
\item{par}{vector of parameters, in the following order: scale, rate and shape}

\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{family}{string; choice of parametric family}

\item{thresh}{vector of thresholds}

\item{weights}{weights for observations}

\item{status}{integer vector giving status of an observation. If \code{NULL} (default), this argument is computed internally based on \code{type}.}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments for optimization, currently ignored.}
}
\value{
log-likelihood values
}
\description{
Computes the log-likelihood for various parametric models suitable for threshold
exceedances. If threshold is non-zero, then only right-censored, observed event time and interval censored
data whose timing exceeds the thresholds are kept.
}
\examples{
data(ewsim, package = "longevity")
nll_elife(par = c(5, 0.3),
          family = "gp",
          arguments = ewsim)
}
