% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{lol.project.pca}
\alias{lol.project.pca}
\title{Principal Component Analysis (PCA)}
\usage{
lol.project.pca(X, r, ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{r}{the rank of the projection.}

\item{...}{trailing args.}
}
\value{
A list of class \code{embedding} containing the following:
\item{A}{\code{[d, r]} the projection matrix from \code{d} to \code{r} dimensions.}
\item{d}{\code{[r]} the signular values associated with the projection matrix \code{A}.}
\item{Xr}{\code{[n, r]} the \code{n} data points in reduced dimensionality \code{r}.}
}
\description{
A function that performs PCA on data.
}
\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.project.pca(X=X, r=2)  # use pca to project into 2 dimensions
}
\author{
Eric Bridgeford
}
