% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Firmdata}
\alias{Firmdata}
\title{Open DART firm data}
\format{
A data frame with 2073 rows and 24 variables:
\describe{
  \item{corpcode}{Firm code}
  \item{market}{"KOSPI" or "KOSDAQ"}
  \item{kospi}{=1 if KOSPI}
  \item{kosdaq}{=1 if KOSDAQ}
  \item{indcode}{industry code}
  \item{sic0}{one of A, C, GHI, DEF, JK, and Others}
  \item{sic1}{A, B, ..., U (top SIC categories)}
  \item{sic2}{2-digit SIC}
  \item{sic3}{3-digit SIC}
  \item{estdate}{establishment date in yyyymmdd}
  \item{estyear}{establishment year}
  \item{age}{=2018-estyear}
  \item{inkorea}{=1 if the firm operates in Korea}
  \item{status}{="000" if firm information is available}
  \item{nemp}{number of employees}
  \item{totsal}{total annual salary paid (sum)}
  \item{avgten}{average tenure in years}
  \item{avgsal}{=totsal/nemp}
  \item{fstype}{CFS or OFS}
  \item{accstatus}{="000" if account information is available}
  \item{sales}{sales in KRW}
  \item{oprofit}{operating profit in KRW}
  \item{netinc}{net income in KRW}
}
}
\source{
opendart.fss.or.kr
}
\usage{
data(Firmdata)
}
\description{
Korean firm data for 2018 in KOSPI and KOSDAQ
}
\author{
\packageAuthor{loedata}
}
\keyword{datasets}
