% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca-r2.R
\name{lod_cca}
\alias{lod_cca}
\title{Single pollutant complete case analysis.}
\usage{
lod_cca(formula, df, type)
}
\arguments{
\item{formula}{A R formula in the form outcome ~ exposure + covariates.}

\item{df}{A data.frame that contains the variables \code{formula}
references.}

\item{type}{The type of regression to perform. Acceptable options are
linear and logistic.}
}
\description{
lod_cca is a helper function that does complete case analysis for
single pollutant models.  The function can be used to compare with clmi.
}
\examples{
library(lodi)
# load lodi's toy data
data("toy_data")
x <- lod_cca(case_cntrl ~ poll + smoking + gender, toy_data, logistic)
# see the fit model
x$model
}
