%%	OK

\name{locCteWeights}
\alias{locCteWeightsC}
\alias{locLinWeightsC}
\alias{locWeightsEvalC}
\alias{locWeightsEval}
\title{ Local Polynomial Weights }
\description{
  Local Constant and local Linear estimator with weight.
}
\usage{
  locCteWeightsC(x, xeval, bw, kernel, weig = rep(1, length(x))) 
  locLinWeightsC(x, xeval, bw, kernel, weig = rep(1, length(x)))
  locWeightsEval(lpweig, y) 
  locWeightsEvalC(lpweig, y) 
}
\arguments{
	\item{x}{ x covariate data values. }
	\item{y}{ y response data values. }
	\item{xeval}{ Vector with evaluation points. }
	\item{bw}{ Smoothing parameter, bandwidth. }
	\item{kernel}{ Kernel used to perform the estimation, see \code{\link{Kernels}}}
	\item{weig}{ Vector of weights for observations. }
	\item{lpweig}{ Local polynomial weights $(X^TWX)^{-1}X^TW$ evaluated at \code{xeval} matrix. }
}
\details{
	\code{locCteWeightsC} and \code{locLinWeightsC} computes local 
	constant and local linear weights, say any of the entries of 
	the vector $(X^TWX)^{-1}X^TW$ for $p=0$ and $p=1$ resp. 
	\code{locWeightsEvalC} and \code{locWeightsEval} computes local
	the estimator for a given vector of responses \code{y}
}
\value{
	\code{locCteWeightsC} and \code{locLinWeightsC} returns a list
	with two components
	\item{den}{Estimation of $(n*bw*f(x))^{p+1}$.}
	\item{locWeig}{$(X^TWX)^{-1}X^TW$ evaluated at \code{xeval} Matrix.}
	\code{locWeightsEvalC} and \code{locWeightsEval} returns the
	vector with the estimation. It performs the matrix multiplication
	between \code{locWeig} and \code{y} to obtain the estimation at 
	given \code{xeval} points.
}
\references{ 
Fan, J. and Gijbels, I.
\emph{ Local polynomial modelling and its applications\/}.
Chapman \& Hall, London (1996).

Wand, M.~P. and Jones, M.~C.
\emph{ Kernel smoothing\/}.
Chapman and Hall Ltd., London (1995).
}
\author{ Jorge Luis Ojeda Cabrera.}
\seealso{ 
\code{\link{Kernels}}, \link{locpol}. 
}
\examples{
	size <- 200
	sigma <- 0.25
	deg <- 1
	kernel <- EpaK
	bw <- .25
	xeval <- 0:100/100
	regFun <- function(x) x^3
	x <- runif(size)
	y <- regFun(x) + rnorm(x, sd = sigma)
	d <- data.frame(x, y)
	lcw <- locCteWeightsC(d$x, xeval, bw, kernel)$locWeig
	lce <- locWeightsEval(lcw, y) 
	lceB <- locCteSmootherC(d$x, d$y, xeval, bw, kernel)$beta0
	mean((lce-lceB)^2)
    llw <- locLinWeightsC(d$x, xeval, bw, kernel)$locWeig
	lle <- locWeightsEval(llw, y) 
	lleB <- locLinSmootherC(d$x, d$y, xeval, bw, kernel)$beta0
	mean((lle-lleB)^2)
}
\keyword{ nonparametric }
\keyword{ smooth }
