% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_mte_tilde.R
\name{eval_mte_tilde}
\alias{eval_mte_tilde}
\title{Evaluate Marginal Treatment Effects Projected onto the Propensity Score}
\usage{
eval_mte_tilde(object, p, u)
}
\arguments{
\item{object}{An object of class \code{mte} returned by \code{\link{mte}}.}

\item{p}{Value(s) of the propensity score \eqn{p} at which MTE_tilde(p, u) is evaluated.}

\item{u}{Value(s) of the latent resistance \eqn{u} at which MTE_tilde(p, u) is evaluated.}
}
\value{
A list of four elements.
  \item{mte_tilde}{Estimates of MTE_tilde(p, u)}
  \item{p_comp}{Estimates of \eqn{E[\mu_1(X)-\mu_0(X)|P(Z)=p]}}
  \item{u_comp}{Estimates of \eqn{E[\eta|U=u]}}
  \item{model}{Fitted model for \eqn{E[\mu_1(X)-\mu_0(X)|P(Z)=p]}}
}
\description{
\code{eval_mte_tilde} is a function that evaluates marginal treatment effects
projected onto the estimated propensity score (Zhou and Xie 2019). The projection
is done via the function \code{\link[mgcv]{gam}} with default parameters.
}
\examples{
 mte_fit <- mte(selection = d ~ x + z, outcome = y ~ x,
 method = "localIV", data = toydata)

 # heatmap showing MTE_tilde(p, u)
 p <- rep(seq(0.05, 0.95, 0.1), 10)
 u <- rep(seq(0.05, 0.95, 0.1), each = 10)
 out1 <- eval_mte_tilde(mte_fit, p = p, u = u)
 if(requireNamespace("plotly", quietly = TRUE)){
   plotly::plot_ly(x = u, y = p, z = out1$mte_tilde, type = "heatmap")
 }

 # heatmap showing MPRTE_tilde(p)
 p <- seq(0.05, 0.95, 0.1)
 u <- p
 out2 <- eval_mte_tilde(mte_fit, p = p, u = u)
 if(requireNamespace("plotly", quietly = TRUE)){
   plotly::plot_ly(x = u, y = p, z = out2$mte_tilde, type = "heatmap")
 }

 # decompose MPRTE_tilde(p) into the p-component and the u-component
 y <- with(out2, cbind(mte_tilde, p_comp, u_comp))
 matplot(x = p, y = y, type = "l", lwd = 2)

}
\references{
Zhou, Xiang and Yu Xie. 2019. "\href{https://www.journals.uchicago.edu/doi/abs/10.1086/702172}{Marginal Treatment Effects from A Propensity Score Perspective.}" Journal of Political Economy.

Zhou, Xiang and Yu Xie. 2019. "\href{https://scholar.harvard.edu/files/xzhou/files/zhou-xie2019_hte.pdf}{Heterogeneous Treatment Effects in the Presence of Self-selection:
  a Propensity Score Perspective.}" Sociological Methodology.
}
