% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.lm.R
\name{cv.lm}
\alias{cv.lm}
\title{Cross-validation for an object of class 'lm'}
\usage{
cv.lm(object, k = 10, ks_test = FALSE, log = FALSE, seed = NULL, ...)
}
\arguments{
\item{object}{Object of class 'lm'}

\item{k}{Integer, number of folds}

\item{ks_test}{Boolean, if \code{TRUE}, a Kolmogorov-Smirnov test is carried out. See details.}

\item{log}{Boolean, specifies whether \code{object} contains a fit to the response vector \eqn{Y} or its logarithm \eqn{\log Y}}

\item{seed}{Integer, seed for the random number generator. The seed is not set when \code{seed} equals \code{NULL}.}

\item{...}{Other parameters, not used in the current implementation.}
}
\value{
An object of class 'cvlmvar', which is a list with the following items:
\itemize{
\item \code{MAE} a list with two items
\itemize{
\item \code{mean} the sample mean of the absolute prediction error over the k folds
\item \code{sd} the sample standard deviation of the absolute prediction error over the k folds
}
\item \code{MSE} a list with two items
\itemize{
\item \code{mean} the sample mean of the mean squared prediction error over the k folds
\item \code{sd} the sample standard deviation of the mean squared prediction error over the k folds
}
\item \code{MSE_sqrt} a list with two items
\itemize{
\item \code{mean} the sample mean of the square root of the mean squared prediction error over the k folds
\item \code{sd} the sample standard deviation of the square root of the mean squared prediction error
over the k folds
}
\item \code{KS_distance} a list with two items
\itemize{
\item \code{mean} the sample mean of the Kolmogorov-Smirnov distance over the k folds
\item \code{sd} the sample standard deviation of the Kolmogorov-Smirnov distance over the k folds
}
\item \code{KS_p.value} a list with two items
\itemize{
\item \code{mean} the sample mean of the p-value of Kolmogorov-Smirnov distance over the k folds
\item \code{sd} the sample standard deviation of the p-value of the Kolmogorov-Smirnov distance over the k folds
}
}
The items \code{KS_distance} and \code{KS_p.value} are added only in case \code{ks_test = TRUE}.
}
\description{
k-fold cross-validation for an object of class 'lm'
}
\details{
\code{object} must contain the list-members \code{x} and \code{y}. I.e., it must be created by running
\code{\link[stats]{lm}} with the options \code{x = TRUE} and \code{y = TRUE}.

When \code{ks_test = TRUE}, a Kolmogorov-Smirnov (KS) test is carried out. The test checks whether the
standardized residuals \eqn{(y - \mu) / \sigma} in a fold are distributed as a standard normal distribution. The
KS-distance and the corresponding p-value are calculated for each fold. The test uses the function
\code{\link[stats]{ks.test}}.
}
\examples{
# Create an object of class 'lm'. We use an arbitrary model matrix, an arbitrary parameter
# vector beta and a generated response vector y for the purpose of the example.
library(MASS)

X = model.matrix(~ Sex + Bwt, cats)
beta_mu = c(-0.1, 0.3, 4)

mu = X \%*\% beta_mu

y = rnorm( nrow(X), mean = mu, sd = 0.5)

fit = lm(y ~ ., as.data.frame(X[,-1]), x = TRUE, y = TRUE)

# Carry out a cross-validation
cv = cv.lm(fit)

# Carry out a cross-validation including a Kolmogorov-Smirnov test
cv = cv.lm(fit, ks_test = TRUE)

# Carry out a cross-validation with 5 folds and control the random numbers used
cv = cv.lm(fit, k = 5, seed = 5483)

# Use option 'log = TRUE' if you fit the log of the response vector and require error estimates for
# the response vector itself

fit = lm(log(y) ~ ., as.data.frame(X[,-1]), x = TRUE, y = TRUE)
cv = cv.lm(fit, log = TRUE)

# Print 'cv' using the print-method print.cvlmvar
cv

# Print 'cv' with a specified number of digits
print(cv, digits = 2)
}
\seealso{
\code{\link{cv.lmvar}} is the equivalent function for an object of class 'lmvar'. It is supplied in
case one wants to compare an  'lmvar' fit with an 'lm' fit.

\code{\link{print.cvlmvar}} provides a print-method for an object of class 'cvlmvar'.
}
