% Generated by roxygen2 (4.0.1): do not edit by hand
\name{summary.lmmspline}
\alias{summary.lmmspline}
\title{Summary of a \code{lmmspline} Object}
\usage{
\method{summary}{lmmspline}(object, ...)
}
\arguments{
\item{object}{An object of class \code{lmmspline}.}

\item{...}{Additional arguments which are passed to \code{summary}.}
}
\value{
Summary of the \code{lmmspline} object.
}
\description{
Summarizes the \code{lmmspline} object returned by the \code{\link{lmmSpline}} method. Including the models fitted and parameter used.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
# running for samples in group 1
G1 <- which(kidneySimTimeGroup$group=="G1")
testLMMSplineTG<- lmmSpline(data=kidneySimTimeGroup$data[G1,],
                  time=kidneySimTimeGroup$time[G1],
                  sampleID=kidneySimTimeGroup$sampleID[G1])
summary(testLMMSplineTG)}
}

