% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information-matrices.R
\name{varcomp_vcov}
\alias{varcomp_vcov}
\title{Estimated sampling variance-covariance of variance component
  parameters.}
\usage{
varcomp_vcov(mod, type = "expected", separate_variances = FALSE)
}
\arguments{
\item{mod}{Fitted model of class lmeStruct or glsStruct.}

\item{type}{Type of information matrix. One of \code{"expected"} (the
default), \code{"observed"}, or \code{"average"}.}

\item{separate_variances}{Logical indicating whether to return the Fisher
information matrix for separate level-1 variance components if using
\code{varIdent} function to allow for different variances per stratum.
Default is \code{FALSE}.}
}
\value{
Sampling variance-covariance matrix corresponding to variance
  component parameters of \code{mod}.
}
\description{
Estimate the sampling variance-covariance of variance component
  parameters from a fitted linear mixed effects model (lmeStruct object)
  or generalized least squares model (glsStruct object)
  using the inverse Fisher information.
}
\examples{

library(nlme)
data(Bryant2016)
Bryant2016_RML <- lme(fixed = outcome ~ treatment,
                      random = ~ 1 | school/case,
                      correlation = corAR1(0, ~ session | school/case),
                      data = Bryant2016)
varcomp_vcov(Bryant2016_RML, type = "expected")

Bryant2016_RML2 <- lme(fixed = outcome ~ treatment,
                      random = ~ 1 | school/case,
                      correlation = corAR1(0, ~ session | school/case),
                      weights = varIdent(form = ~ 1 | treatment),
                      data = Bryant2016)
varcomp_vcov(Bryant2016_RML2, separate_variances = TRUE)

}
