% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast.R
\name{future<-,Forecast-method}
\alias{future<-,Forecast-method}
\title{Set future slot of a Forecast object}
\usage{
\S4method{future}{Forecast}(Forecast) <- value
}
\arguments{
\item{Forecast}{Forecast object.}

\item{value}{Vector of values assigned to the future slot of the Forecast.}
}
\value{
\code{\link{Forecast}} object that contains the new future vector.
}
\description{
\code{future} takes a \code{\link{Forecast}} object and sets the future
vector of the forecast.
}
\examples{
my_forecast <- Forecast(
   origin   = c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31"),
   future   = c("2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31"),
   forecast = c(4.21, 4.27, 5.32, 5.11),
   realized = c(4.40, 4.45, 4.87, 4.77),
   h_ahead  = 4L
)

future(my_forecast) <- c("2012-04-01", "2012-07-01", "2012-10-01", "2013-01-01")

}
