% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-list.r
\name{gen.list.char}
\alias{gen.list.char}
\alias{gen.vector.char}
\alias{gen.named.list}
\alias{gen.named.vector}
\alias{gen.named.data.frame}
\title{Generate Characters and Named Lists, Vectors and Data Frames with List Comprehension}
\usage{
gen.list.char(str, ...)

gen.vector.char(str, ...)

gen.named.list(str, expr, ...)

gen.named.vector(str, expr, ...)

gen.named.data.frame(str, expr, ...)
}
\arguments{
\item{str}{A character pattern, containing expressions to be evaluated in \code{\{\}}-brackets. 
Double brackets are transformed into a single bracket without evaluating the inner expression.
For instance, \code{"var{x + 1}_{{a}}"} is transformed into \code{"var2_{a}"} for \code{x = 1}.}

\item{...}{Arbitrary many variable ranges and conditions.}

\item{expr}{A base expression containing free variables which is evaluated for all combinations of variables.}
}
\value{
The functions \code{gen.list.char} and \code{gen.vector.char} return lists and vectors of characters.

The functions \code{gen.named.list}, \code{gen.named.vector}, \code{gen.named.data.frame} return lists, vectors, and data frames.
The work very similar to their counterparts without ".named".
Additionally the vector of characters, induced by \code{str}, serves as a vector of names for the generated structures. 
In case of lists or vectors, the result is a named list or a named vector. For data frames, the names are taken as row names.
}
\description{
Functions to transform patterns with placeholders into characters or into names of lists, vectors, or data frames,
based on variable ranges and additional conditions.
}
\details{
The free variables in the inner expressions (i.e., the content of the \code{\{\}}-brackets) of \code{expr} are evaluated in the same way as expressions in \code{\link{gen.list}}.

See \code{\link{gen.list}} for more details on the \code{expr} and \code{...} parameters.
}
\examples{
# sum up 1:i for i in 1:5
gen.named.list("sum_to_{x}", sum(1:x), x = 1:5)

# same as above, but return as text
gen.list.char("sum of 1 to {x} is {sum(1:x)}", x = 1:5)

}
\seealso{
\code{\link{gen.list}} for explanations on list and vector comprehension,
  and \link{listcompr} for an overview of all list comprehension functions.
}
