% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{Configuration}
\alias{Configuration}
\alias{getConfig}
\alias{setConfig}
\title{liquidSVM model configuration parameters.}
\usage{
getConfig(model, name)

setConfig(model, name, value)
}
\arguments{
\item{model}{the model}

\item{name}{the name}

\item{value}{the value}
}
\value{
the value of the configuration parameter
}
\description{
Different parameters configure different aspects of training/selection/testing.
The learning scenarios set many parameters to corresponding default values,
and these can again be changed by the user. Therefore the order in which they
are specified can be important.
}
\section{Overview of Configuration Parameters}{

\describe{
\item{\code{display}}{
This parameter determines the amount of output of you see at the screen: The larger its value is, the more you see. This can help as a progress indication.
}

\item{\code{scale}}{
If set to a true value then for every feature in the training data a scaling is calculated so that its values lie in the interval \eqn{[0,1]}. The training then is performed using these scaled values and any testing data is scaled transparently as well.

Because SVMs are not scale-invariant any data should be scaled for two main reasons: First that all features have the same weight, and second to assure that the default gamma parameters that liquidSVM provide remain meaningful.

If you do not have scaled the data previously this is an easy option.
}

\item{\code{threads}}{
This parameter determines the number of cores used for computing the kernel matrices, the validation error, and the test error.
\itemize{
\item \code{threads=0} (default) means that all physical cores of your CPU run one thread.

\item \code{threads=-1} means that all but one physical cores of your CPU run one thread.
}
}

\item{\code{partition_choice}}{
This parameter determines the way the input space is partitioned. This allows larger data sets for which the kernel matrix does not fit into memory.
\itemize{
\item \code{partition_choice=0} (default) disables partitioning.

\item \code{partition_choice=6} gives usually highest speed.

\item \code{partition_choice=5} gives usually the best test error.
}
}

\item{\code{grid_choice}}{
This parameter determines the size of the hyper- parameter grid used during the training phase. Larger values correspond to larger grids. By default, a 10x10 grid is used. Exact descriptions are given in the next section.
}

\item{\code{adaptivity_control}}{
This parameter determines, whether an adaptive grid search heuristic is employed. Larger values lead to more aggressive strategies. The default \code{adaptivity_control = 0} disables the heuristic.
}

\item{\code{random_seed}}{
This parameter determines the seed for the random generator. \code{random_seed} = -1 uses the internal timer create the seed. All other values lead to repeatable behavior of the svm.
}

\item{\code{folds}}{
How many folds should be used.
}
}
}

\section{Specialized configuration parameters}{

Parameters for regression (least-squares, quantile, and expectile)

\describe{
\item{\code{clipping}}{This parameter determines whether the decision functions should be clipped at the specified value. The value \code{clipping} = -1.0 leads to an adaptive clipping value, whereas \code{clipping} = 0 disables clipping.}
}

Parameter for multiclass classification determine the multiclass strategy: \code{mc-type=0} : AvA with hinge loss. \code{mc-type=1} : OvA with least squares loss. \code{mc-type=2} : OvA with hinge loss. \code{mc-type=3} : AvA with least squares loss.

Parameters for Neyman-Pearson Learning

\describe{
\item{\code{class}}{
The class, the \code{constraint} is enforced on.
}

\item{\code{constraint}}{
The constraint on the false alarm rate. The script actually considers a couple of values around the value of \code{constraint} to give the user an informed choice.
}
}
}

\section{Hyperparameter Grid}{

For Support Vector Machines two hyperparameters need to be determined:
\itemize{
\item \code{gamma} the bandwith of the kernel

\item \code{lambda} has to be chosen such that neither over- nor underfitting happen. lambda values are the classical regularization parameter in front of the norm term.
}

liquidSVM has a built-in a cross-validation scheme to calculate validation errors for many values of these hyperparameters and then to choose the best pair. Since there are two parameters this means we consider a two-dimensional grid.

For both parameters either specific values can be given or a geometrically spaced grid can be specified.

\describe{
\item{\code{gamma_steps}, \code{min_gamma}, \code{max_gamma}}{
specifies in the interval between \code{min_gamma} and \code{max_gamma} there should be \code{gamma_steps} many values
}

\item{\code{gammas}}{
e.g. \code{gammas=c(0.1,1,10,100)} will do these four gamma values
}

\item{\code{lambda_steps}, \code{min_lambda}, \code{max_lambda}}{
specifies in the interval between \code{min_lambda} and \code{max_lambda} there should be \code{lambda_steps} many values
}

\item{\code{lambdas}}{
e.g. \code{lambdas=c(0.1,1,10,100)} will do these four lambda values
}

\item{\code{c_values}}{
the classical term in front of the empirical error term, e.g. \code{c_values=c(0.1,1,10,100)} will do these four cost values (basically inverse of \code{lambdas})
}
}

Note the min and max values are scaled according the the number of samples, the dimensionality of the data sets, the number of folds used, and the estimated diameter of the data set.

Using \code{grid_choice} allows for some general choices of these parameters
\tabular{llll}{

\code{grid_choice} \tab 
0 \tab 
1 \tab 
2
\cr

\code{gamma_steps} \tab 
10 \tab 
15 \tab 
20
\cr


\code{lambda_steps} \tab 
10 \tab 
15 \tab 
20
\cr


\code{min_gamma} \tab 
0.2 \tab 
0.1 \tab 
0.05
\cr


\code{max_gamma} \tab 
5.0 \tab 
10.0 \tab 
20.0
\cr


\code{min_lambda} \tab 
0.001 \tab 
0.0001 \tab 
0.00001
\cr


\code{max_lambda} \tab 
0.01 \tab 
0.01 \tab 
0.01
\cr

}
Using negative values of \code{grid_choice} we create a grid with listed gamma and lambda values:
\tabular{ll}{

\code{grid_choice} \tab 
-1
\cr

\code{gammas} \tab 
\code{c(10.0, 5.0, 2.0, 1.0, 0.5, 0.25, 0.1, 0.05)}
\cr


\code{lambdas} \tab 
\code{c(1.0, 0.1, 0.01, 0.001, 0.0001, 0.00001, 0.000001, 0.0000001)}
\cr

}\tabular{ll}{

\code{grid_choice} \tab 
-2
\cr

\code{gammas} \tab 
\code{c(10.0, 5.0, 2.0, 1.0, 0.5, 0.25, 0.1, 0.05)}
\cr


\code{c_values} \tab 
\code{c(0.01, 0.1, 1, 10, 100, 1000, 10000)}
\cr

}
}

\section{Adaptive Grid}{

An adaptive grid search can be activated. The higher the values of \code{MAX_LAMBDA_INCREASES} and \code{MAX_NUMBER_OF_WORSE_GAMMAS} are set the more conservative the search strategy is. The values can be freely modified.
\tabular{lll}{

\code{ADAPTIVITY_CONTROL} \tab 
1 \tab 
2
\cr

\code{MAX_LAMBDA_INCREASES} \tab 
4 \tab 
3
\cr


\code{MAX_NUMBER_OF_WORSE_GAMMAS} \tab 
4 \tab 
3
\cr

}
}

\section{Cells}{

A major issue with SVMs is that for larger sample sizes the kernel matrix does not fit into the memory any more. Classically this gives an upper limit for the class of problems that traditional SVMs can handle without significant runtime increase. Furthermore also the time complexity is at least \eqn{O(n^2)}.

liquidSVM implements two major concepts to circumvent these issues. One is random chunks which is known well in the literature. However we prefer the new alternative of splitting the space into spatial cells and use local SVMs on every cell.

If you specify \code{useCells=TRUE} then the sample space \eqn{X} gets partitioned into a number of cells. The training is done first for cell 1 then for cell 2 and so on. Now, to predict the label for a value \eqn{x\in X} liquidSVM first finds out to which cell this \eqn{x} belongs and then uses the SVM of that cell to predict a label for it.
\preformatted{
If you run into memory issues turn cells on: \code{useCells=TRUE}
}

This is quite performant, since the complexity in both time and memore are both \eqn{O(\mbox{CELLSIZE} \times n)} and this holds both for training as well as testing! It also can be shown that the quality of the solution is comparable, at least for moderate dimensions.

The cells can be configured using the \code{partition_choice}:
\enumerate{
\item 
This gives a partition into random chunks of size 2000

\code{VORONOI=c(1, 2000)}

\item 
This gives a partition into 10 random chunks

\code{VORONOI=c(2, 10)}

\item 
This gives a Voronoi partition into cells with radius not larger than 1.0. For its creation a subsample containing at most 50.000 samples is used.

\code{VORONOI=c(3, 1.0, 50000)}

\item 
This gives a Voronoi partition into cells with at most 2000 samples (approximately). For its creation a subsample containing at most 50.000 samples is used. A shrinking heuristic is used to reduce the number of cells.

\code{VORONOI=c(4, 2000, 1, 50000)}

\item 
This gives a overlapping regions with at most 2000 samples (approximately). For its creation a subsample containing at most 50.000 samples is used. A stopping heuristic is used to stop the creation of regions if 0.5 * 2000 samples have not been assigned to a region, yet.

\code{VORONOI=c(5, 2000, 0.5, 50000, 1)}

\item 
This splits the working sets into Voronoi like with \code{PARTITION_TYPE=4}. Unlike that case, the centers for the Voronoi partition are found by a recursive tree approach, which in many cases may be faster.

\code{VORONOI=c(6, 2000, 1, 50000, 2.0, 20, 4,)}
}

The first parameter values correspond to \code{NO_PARTITION}, \code{RANDOM_CHUNK_BY_SIZE}, \code{RANDOM_CHUNK_BY_NUMBER}, \code{VORONOI_BY_RADIUS}, \code{VORONOI_BY_SIZE}, \code{OVERLAP_BY_SIZE}
}

\section{Weights}{
\itemize{
\item 
qt, ex: Here the number of considered tau-quantiles/expectiles as well as the considered tau-values are defined. You can freely change these values but notice that the list of tau-values is space-separated!


\item 
npl, roc: Here, you define, which weighted classification problems will be considered. The choice is usually a bit tricky. Good luck ...

}
\preformatted{NPL:
WEIGHT_STEPS=10
MIN_WEIGHT=0.001
MAX_WEIGHT=0.5
GEO_WEIGHTS=1

ROC:
WEIGHT_STEPS=9
MAX_WEIGHT=0.9
MIN_WEIGHT=0.1
GEO_WEIGHTS=0}
}

\section{More Advanced Parameters}{

The following parameters should only employed by experienced users and are self-explanatory for these:

\describe{
\item{\code{KERNEL}}{
specifies the kernel to use, at the moment either \code{GAUSS_RBF} or \code{POISSON}
}

\item{\code{RETRAIN_METHOD}}{
After training on grids and folds there are only solutions on folds. In order to construct a global solution one can either retrain on the whole training data (\code{SELECT_ON_ENTIRE_TRAIN_SET}) or the (partial) solutions from the training are kept and combined using voting (\code{SELECT_ON_EACH_FOLD} default)
}

\item{\code{store_solutions_internally}}{
If this is true (default in all applicable cases) then the solutions of the train phase are stored and can be just reused in the select phase. If you slowly run out of memory during the train phase maybe disable this. However then in the select phase the best models have to be trained again.
}
}

For completeness here are some values that usually get set by the learning scenario

\describe{
\item{\code{SVM_TYPE}}{
\code{KERNEL_RULE}, \code{SVM_LS_2D}, \code{SVM_HINGE_2D}, \code{SVM_QUANTILE}, \code{SVM_EXPECTILE_2D}, \code{SVM_TEMPLATE}
}

\item{\code{LOSS_TYPE}}{
\code{CLASSIFICATION_LOSS}, \code{MULTI_CLASS_LOSS}, \code{LEAST_SQUARES_LOSS}, \code{WEIGHTED_LEAST_SQUARES_LOSS}, \code{PINBALL_LOSS}, \code{TEMPLATE_LOSS}
}

\item{\code{VOTE_SCENARIO}}{
\code{VOTE_CLASSIFICATION}, \code{VOTE_REGRESSION}, \code{VOTE_NPL}
}

\item{\code{KERNEL_MEMORY_MODEL}}{
\code{LINE_BY_LINE}, \code{BLOCK}, \code{CACHE}, \code{EMPTY}
}

\item{\code{FOLDS_KIND}}{
\code{FROM_FILE}, \code{BLOCKS}, \code{ALTERNATING}, \code{RANDOM}, \code{STRATIFIED}, \code{RANDOM_SUBSET}
}

\item{\code{WS_TYPE}}{
\code{FULL_SET}, \code{MULTI_CLASS_ALL_VS_ALL}, \code{MULTI_CLASS_ONE_VS_ALL}, \code{BOOT_STRAP}
}
}
}

