% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initControls.R
\name{getGrassParams4X}
\alias{getGrassParams4X}
\title{Initialize and set up 'GRASS GIS' and \code{rgrass7} for the usage on 'Linux' OS}
\usage{
getGrassParams4X(setDefaultGrass = NULL, MP = "/usr", verSelect = FALSE)
}
\arguments{
\item{setDefaultGrass}{default = NULL will force a search for 'GRASS GIS' You may provide a valid combination as c("C:/OSGeo4W64","grass-7.0.5","osgeo4w")}

\item{MP}{mount point to be searched. default is "usr"}

\item{verSelect}{if TRUE you must interactivley selcect between alternative installations}
}
\description{
Initialize and set up \link{rgrass7}  for 'Linux'
}
\details{
During the rsession you will have full access to GRASS7 GIS via the \link{rgrass7} wrappe. Additionally you may use also use the API calls of GRASS7 via the command line.
}
\examples{
\dontrun{
# automatic retrieval of the GRASS7 enviroment settings
getGrassParams4X()

# typical standalone installation
getGrassParams4X("/usr/bin/grass72")

# typical user defined installation (compiled sources)
getGrassParams4X("/usr/local/bin/grass72")
}
}

