% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.match.R
\name{histDetection}
\alias{histDetection}
\title{Histogram of detection}
\usage{
histDetection(lr, ld, matched, plot = TRUE)
}
\arguments{
\item{lr}{data.frame or matrix. 3D coordinates (X Y Height) of reference positions}

\item{ld}{data.frame or matrix. 3D coordinates (X Y Height) of detected positions}

\item{matched}{data.frame. contains pair indices, typically returned by \code{\link{treeMatching}}}

\item{plot}{boolean. should the histogram be displayed or not}
}
\value{
A list with three numerics: numbers of true detections, omissions and false detections
}
\description{
Displays the histogram of tree heights of three categories: true detections, omissions, and false detections.
}
\examples{
# create reference and detected trees
ref.trees <- cbind(c(1,4,3,4,2), c(1,1,2,3,4), c(15,18,20,10,11))
def.trees <- cbind(c(2,2,4,4), c(1,3,4,1), c(16,19,9,15))
#
# tree matching with different buffer size
match1 <- treeMatching(ref.trees, def.trees)
match2 <- treeMatching(ref.trees, def.trees, deltaGround=2, hPrec=0)
#
# corresponding number of detections
histDetection(ref.trees, def.trees, match1)
histDetection(ref.trees, def.trees, match2)

}
\seealso{
\code{\link{treeMatching}}
}
