% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog_retile.r
\name{catalog_retile}
\alias{catalog_retile}
\title{Retile a catalog}
\usage{
catalog_retile(ctg, path, prefix, ext = c("las", "laz"), alignment = c(0,
  0), ...)
}
\arguments{
\item{ctg}{A \link[lidR:catalog]{LAScatalog} object}

\item{path}{string. The folder where the new files should be saved.}

\item{prefix}{character. The prefix of the written file name. It can be missing, in which case if the
catalog is processed by file, the original name of the file will be retained.}

\item{ext}{character. The format of the written files. Can be ".las" or ".laz".}

\item{alignment}{numeric vector. A vector of size 2 (x and y coordinates, respectively) to align the
pattern. By default the alignment is made along (0,0) as in all LAScatalog processes, meaning the edge
of a virtual tile will belong on x = 0 and y = 0 and all the the others will be multiples of the
tiling size.}

\item{...}{extra parameter 'filter' to pass to \link{readLAS} (readLAS is not actually called but
the parameter can be passed anyway).}
}
\value{
A new \code{LAScatalog} object
}
\description{
Splits or merges files to reshape the original catalog files (.las or .laz) into smaller or larger
files. It also enables the addition or removal of a buffer around the tiles. The new files are written
in a dedicated folder. The function first displays the layout of the new tiling pattern and then asks
the user to validate the command.
}
\details{
Internally the function reads and writes the clusters defined by the internal processing options of a
\link[lidR:LAScatalog-class]{LAScatalog} (see also \link{catalog}). Thus the function is flexible and
enables the user to retile the dataset, retile while adding or removing a buffer (negative buffers are
allowed), or optionally to compress the data by retiling without changing the pattern but by changing
the format (las/laz).\cr\cr

Note that this function is not actually very useful since \code{lidR} manages everything
(clipping, processing, buffering, ...) internally using the proper options. Thus, retiling may be useful
for working in other software for example, but not in \code{lidR}.
}
\examples{
\dontrun{
ctg = catalog("path/to/catalog")

# Create a new set of .las files 500 by 500 wide in the folder
# path/to/new/catalog/ and iteratively named Forest_001.las, Forest_002.las
# Forest_003.las, and so on.

buffer(ctg) = 0
by_file(ctg) = FALSE
tiling_size(ctg) = 500
newctg = catalog_retile(ctg, "path/to/new/catalog", "Forest_")

# Create a new set of .las files equivalent to the original one
# but extended with a 50 m buffer in the folder path/to/new/catalog/
# and iteratively named named after the original files.

buffer(ctg) = 50
by_file(ctg) = TRUE
newctg = catalog_retile(ctg, "path/to/new/catalog")

# Being flexible this function can also compress a catalog but this is
# not really useful since laszip from LAStools is a free and open source
# program.

buffer(ctg) = 0
by_file(ctg) = TRUE
newctg = catalog_retile(ctg, "path/to/compressed/file",  ext = "laz")
}
}
\seealso{
\link{catalog}
}
