/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_DIAGNOSTICINDIVIDUALPARAMS_H
#define _SO_DIAGNOSTICINDIVIDUALPARAMS_H

#include <so/Table.h>

/** \struct so_DiagnosticIndividualParams
	 \brief A structure representing an SO/SOBlock/ModelDiagnostic/DiagnosticIndividualParams element
*/
typedef struct so_DiagnosticIndividualParams so_DiagnosticIndividualParams;

/** \memberof so_DiagnosticIndividualParams
 * Create a new empty so_DiagnosticIndividualParams structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_DiagnosticIndividualParams_copy, so_DiagnosticIndividualParams_free
 */
so_DiagnosticIndividualParams *so_DiagnosticIndividualParams_new();
/** \memberof so_DiagnosticIndividualParams
 * Create a copy of a so_DiagnosticIndividualParams structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_DiagnosticIndividualParams_new
 */
so_DiagnosticIndividualParams *so_DiagnosticIndividualParams_copy(so_DiagnosticIndividualParams *self);
/** \memberof so_DiagnosticIndividualParams
 * Free all memory associated with a so_DiagnosticIndividualParams structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_DiagnosticIndividualParams_new
 */
void so_DiagnosticIndividualParams_free(so_DiagnosticIndividualParams *self);
void so_DiagnosticIndividualParams_ref(so_DiagnosticIndividualParams *self);
void so_DiagnosticIndividualParams_unref(so_DiagnosticIndividualParams *self);
/** \memberof so_DiagnosticIndividualParams
 * Get the RandomEffects element
 * \param self - pointer to a so_DiagnosticIndividualParams
 * \return A pointer to the structure representing the RandomEffects element
 * \sa so_DiagnosticIndividualParams_set_RandomEffects
 */
so_Table *so_DiagnosticIndividualParams_get_RandomEffects(so_DiagnosticIndividualParams *self);
/** \memberof so_DiagnosticIndividualParams
 * Get the IndivParamsCovariates element
 * \param self - pointer to a so_DiagnosticIndividualParams
 * \return A pointer to the structure representing the IndivParamsCovariates element
 * \sa so_DiagnosticIndividualParams_set_IndivParamsCovariates
 */
so_Table *so_DiagnosticIndividualParams_get_IndivParamsCovariates(so_DiagnosticIndividualParams *self);
/** \memberof so_DiagnosticIndividualParams
 * Get the DistributionIndivParams element
 * \param self - pointer to a so_DiagnosticIndividualParams
 * \return A pointer to the structure representing the DistributionIndivParams element
 * \sa so_DiagnosticIndividualParams_set_DistributionIndivParams
 */
so_Table *so_DiagnosticIndividualParams_get_DistributionIndivParams(so_DiagnosticIndividualParams *self);
/** \memberof so_DiagnosticIndividualParams
 * Set the RandomEffects element
 * \param self - pointer to a so_DiagnosticIndividualParams
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_DiagnosticIndividualParams_get_RandomEffects
 */
void so_DiagnosticIndividualParams_set_RandomEffects(so_DiagnosticIndividualParams *self, so_Table *value);
/** \memberof so_DiagnosticIndividualParams
 * Set the IndivParamsCovariates element
 * \param self - pointer to a so_DiagnosticIndividualParams
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_DiagnosticIndividualParams_get_IndivParamsCovariates
 */
void so_DiagnosticIndividualParams_set_IndivParamsCovariates(so_DiagnosticIndividualParams *self, so_Table *value);
/** \memberof so_DiagnosticIndividualParams
 * Set the DistributionIndivParams element
 * \param self - pointer to a so_DiagnosticIndividualParams
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_DiagnosticIndividualParams_get_DistributionIndivParams
 */
void so_DiagnosticIndividualParams_set_DistributionIndivParams(so_DiagnosticIndividualParams *self, so_Table *value);
/** \memberof so_DiagnosticIndividualParams
 * Create a new RandomEffects element and insert it into the so_DiagnosticIndividualParams
 * \param self - pointer to a so_DiagnosticIndividualParams
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_DiagnosticIndividualParams_create_RandomEffects(so_DiagnosticIndividualParams *self);
/** \memberof so_DiagnosticIndividualParams
 * Create a new IndivParamsCovariates element and insert it into the so_DiagnosticIndividualParams
 * \param self - pointer to a so_DiagnosticIndividualParams
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_DiagnosticIndividualParams_create_IndivParamsCovariates(so_DiagnosticIndividualParams *self);
/** \memberof so_DiagnosticIndividualParams
 * Create a new DistributionIndivParams element and insert it into the so_DiagnosticIndividualParams
 * \param self - pointer to a so_DiagnosticIndividualParams
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_DiagnosticIndividualParams_create_DistributionIndivParams(so_DiagnosticIndividualParams *self);

#endif
