% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the-web.R
\name{worldcat_permalink_from_oclc_number}
\alias{worldcat_permalink_from_oclc_number}
\title{Get WorldCat catalog permalinks from OCLC numbers}
\usage{
worldcat_permalink_from_oclc_number(x)
}
\arguments{
\item{x}{A string (or vector of strings) of OCLC numbers}
}
\value{
Worldcat permalinks using the OCLC numbers
}
\description{
Takes a string representation of OCLC numbers. Returns permalinks
to the WorldCat catalog entries using those OCLC numbers
}
\details{
If the OCLC number is invalid, the permalink is NA.
No validity check on the URL is performed
}
\examples{

worldcat_permalink_from_oclc_number("1005106045")
# http://www.worldcat.org/oclc/1005106045

# vectorized
worldcat_permalink_from_oclc_number(c("1049727704", NA,
                                      "1005106045"))

}
