% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{normalize_issn}
\alias{normalize_issn}
\title{Attempt to enforce validity and canonical form to ISSN}
\usage{
normalize_issn(x, aggressive = TRUE, pretty = FALSE)
}
\arguments{
\item{x}{A string}

\item{aggressive}{A logical indicating whether aggressive measures
should be taken to try to get the "ISSN"
into a valid form. See "Details" for more info}

\item{pretty}{A logical indicating whether the ISSN should be
prettily hyphenated}
}
\value{
Returns valid ISSN if possible, NA if not
}
\description{
Takes a string representation of an ISSN. Strips all non-digit
and non-"X" characters and checks if it is valid (whether the
check digit works out, etc). User can specify whether "aggressive"
measures should be taken to salvage the malformed ISSN string.
}
\details{
If \code{aggressive} is TRUE, aggressive measures are taken to
try to salvage the malformed ISSN string. If the ISSN, for example,
is 7 digits, and either adding an "X" to the end, or leading "0"s fix it,
this function will return the salvaged ISSN. If the ISSN has
garbage digits/characters in the front and has an "X" check digit,
it will return the salvaged ISSN.
}
\examples{

# adds leading zero
normalize_issn("3785955")                          # "03785955"

# adds X to 7 digit ISSN if valid
normalize_issn("2434561")                          # "2434561X"

normalize_issn("2434561", pretty=TRUE)             # "2434-561X"

# finds correct sequence
normalize_issn("21335212434561X")                  # "2434561X"

# vectorized
normalize_issn(c("__2434__561X", "2434561", "21335212434561X"))
# "2434561X" "2434561X" "2434561X"

}
