% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderFileRotating}
\alias{AppenderFileRotating}
\title{Log to a rotating file}
\description{
Log to a rotating file

Log to a rotating file
}
\details{
An extension of \link{AppenderFile} that rotates logfiles based on certain
conditions. Please refer to the documentation of \code{\link[rotor:rotate]{rotor::rotate()}} for
the meanings of the extra arguments
}
\seealso{
\link{AppenderFileRotatingDate}, \link{AppenderFileRotatingTime}, \code{\link[rotor:rotate]{rotor::rotate()}}

Other Appenders: 
\code{\link{AppenderBuffer}},
\code{\link{AppenderConsole}},
\code{\link{AppenderFileRotatingDate}},
\code{\link{AppenderFileRotatingTime}},
\code{\link{AppenderFile}},
\code{\link{AppenderTable}},
\code{\link{Appender}}
}
\concept{Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderFile]{lgr::AppenderFile}} -> \code{AppenderFileRotating}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{backups}}{A \code{data.frame} containing information on path, file size,
etc... on the available backups of \code{file}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AppenderFileRotating$new()}}
\item \href{#method-append}{\code{AppenderFileRotating$append()}}
\item \href{#method-rotate}{\code{AppenderFileRotating$rotate()}}
\item \href{#method-prune}{\code{AppenderFileRotating$prune()}}
\item \href{#method-set_file}{\code{AppenderFileRotating$set_file()}}
\item \href{#method-set_size}{\code{AppenderFileRotating$set_size()}}
\item \href{#method-set_max_backups}{\code{AppenderFileRotating$set_max_backups()}}
\item \href{#method-set_compression}{\code{AppenderFileRotating$set_compression()}}
\item \href{#method-set_create_file}{\code{AppenderFileRotating$set_create_file()}}
\item \href{#method-set_backup_dir}{\code{AppenderFileRotating$set_backup_dir()}}
\item \href{#method-format}{\code{AppenderFileRotating$format()}}
\item \href{#method-clone}{\code{AppenderFileRotating$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter">}\href{../../lgr/html/Filterable.html#method-add_filter}{\code{lgr::Filterable$add_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter">}\href{../../lgr/html/Filterable.html#method-filter}{\code{lgr::Filterable$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter">}\href{../../lgr/html/Filterable.html#method-remove_filter}{\code{lgr::Filterable$remove_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters">}\href{../../lgr/html/Filterable.html#method-set_filters}{\code{lgr::Filterable$set_filters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout">}\href{../../lgr/html/Appender.html#method-set_layout}{\code{lgr::Appender$set_layout()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold">}\href{../../lgr/html/Appender.html#method-set_threshold}{\code{lgr::Appender$set_threshold()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFile" data-id="show">}\href{../../lgr/html/AppenderFile.html#method-show}{\code{lgr::AppenderFile$show()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$new(
  file,
  threshold = NA_integer_,
  layout = LayoutFormat$new(),
  filters = NULL,
  size = Inf,
  max_backups = Inf,
  compression = FALSE,
  backup_dir = dirname(file),
  create_file = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{size, max_backups, compression, backup_dir, fmt}}{see \code{\link[rotor:rotate]{rotor::rotate()}} for the meaning of these arguments. Note that
\code{fmt} corresponds to \code{format} and \code{backup_dir} to \code{dir}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-append"></a>}}
\if{latex}{\out{\hypertarget{method-append}{}}}
\subsection{Method \code{append()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$append(event)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-rotate}{}}}
\subsection{Method \code{rotate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$rotate(force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-prune"></a>}}
\if{latex}{\out{\hypertarget{method-prune}{}}}
\subsection{Method \code{prune()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$prune(max_backups = self$max_backups)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_file"></a>}}
\if{latex}{\out{\hypertarget{method-set_file}{}}}
\subsection{Method \code{set_file()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$set_file(file)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_size"></a>}}
\if{latex}{\out{\hypertarget{method-set_size}{}}}
\subsection{Method \code{set_size()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$set_size(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_max_backups"></a>}}
\if{latex}{\out{\hypertarget{method-set_max_backups}{}}}
\subsection{Method \code{set_max_backups()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$set_max_backups(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_compression"></a>}}
\if{latex}{\out{\hypertarget{method-set_compression}{}}}
\subsection{Method \code{set_compression()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$set_compression(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_create_file"></a>}}
\if{latex}{\out{\hypertarget{method-set_create_file}{}}}
\subsection{Method \code{set_create_file()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$set_create_file(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_backup_dir"></a>}}
\if{latex}{\out{\hypertarget{method-set_backup_dir}{}}}
\subsection{Method \code{set_backup_dir()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$set_backup_dir(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$format(color = false, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFileRotating$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
