% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-plot.R
\name{plot_api_g}
\alias{plot_api_g}
\title{Plot longitudinal data and/or model fit so that each subject/group has
their own panel}
\usage{
plot_api_g(
  df_data,
  df_signal = NULL,
  df = NULL,
  df_err = NULL,
  teff_signal = NULL,
  teff_obs = NULL,
  i_test = NULL,
  color_signal = color_palette(2)[1],
  color = color_palette(2)[2],
  color_err = colorset("red", "light_highlight"),
  color_vlines = colorset("gray", "mid_highlight"),
  alpha = 1,
  alpha_err = 0.5,
  nrow = NULL,
  ncol = NULL,
  y_transform = function(x) x
)
}
\arguments{
\item{df_data}{A data frame containing the observations.}

\item{df_signal}{A data frame containing the true signal. Omitted if
\code{NULL}.}

\item{df}{A data frame containing the model fit, or a list of data
frames. The list version can be used for example so that each list element
corresponds to the fit computed using one parameter draw. Omitted if
\code{NULL}.}

\item{df_err}{A data frame containing error bars. Omitted if \code{NULL}.
Must be \code{NULL} if \code{df_fit} is a list.}

\item{teff_signal}{A named vector containing true effect times used to
generate the signal. Omitted if \code{NULL}.}

\item{teff_obs}{A named vector containing observed effect times. Omitted if
\code{NULL}.}

\item{i_test}{Indices of test points.}

\item{color_signal}{Line color for true signal.}

\item{color}{Line color for model fit.}

\item{color_err}{Color of the error ribbon.}

\item{color_vlines}{Two line colors for vertical lines
(true and obs. effect time).}

\item{alpha}{Line opacity for model fit.}

\item{alpha_err}{Opacity of the error ribbon.}

\item{nrow}{number of rows, an argument for
\code{\link[ggplot2]{facet_wrap}}}

\item{ncol}{number of columns, an argument for
\code{\link[ggplot2]{facet_wrap}}}

\item{y_transform}{A function to be applied to the third column of
\code{df_data}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Data frames specified in arguments \code{df_data},
\code{df_signal}, \code{df_fit}, and \code{df_fit_err} must have a format
where
\itemize{
  \item the first column is the grouping factor (usually id)
  \item the second column is the x-axis variable (usually age)
  \item a column named \code{y} must contain the y-axis variable
  (not for \code{df_fit_err})
  \item a column named \code{lower} (\code{upper}) must contain the lower
  (upper) bound of error bar (only for \code{df_fit_err})
  \item a column named \code{draw} must be a factor that
  specifies the posterior draw using which the fit has been computed
  (only for \code{df_fit})
}
}
\seealso{
Other internal plot API functions: 
\code{\link{plot_api_c}()}
}
\concept{internal plot API functions}
