% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_tests.R
\name{ind_test}
\alias{ind_test}
\title{Independence tests}
\usage{
ind_test(lg_object, h = function(x) x^2, S = function(y)
  as.logical(rep(1, nrow(y))), bootstrap_type = "plain",
  block_length = NULL, n_rep = 1000)
}
\arguments{
\item{lg_object}{An object of type \code{lg}, as produced by the
\code{lg_main}-function. The data must be two dimensional.}

\item{h}{The \code{h}-function used in the calculation of the test statistic.
The default value is \code{h(x) = x^2}.}

\item{S}{The integration area for the test statistic. Must be a logical
function that accepts an n x 2 matrix and returns TRUE if a row is in S.}

\item{bootstrap_type}{The bootstrap method. Choose "plain" for the ordinary
nonparametric bootstrap valid for independence test for iid data and for
serial dependence within a time series. Choose "stationary" or "block" for
a test for cross dependence between two time series.}

\item{block_length}{Block length if using block bootstrap for the cross
dependence test. Calculated by \code{np::b.star()} if not supplied.}

\item{n_rep}{Number of bootstrap replications.}
}
\value{
A list containing the test result as well as various parameters. The
  elements are:

  \itemize{
    \item \code{lg_object} The lg-object supplied by the user.
    \item \code{observed} The observed value of the test statistic.
    \item \code{replicated} The replicated values of the test statistic.
    \item \code{bootstrap_type} The bootstrap type.
    \item \code{block_length} The block length used for the block bootstrap.
    \item \code{p_value} The p-value of the test.
  }
}
\description{
Independence tests based on the local Gaussian correlation
}
\details{
Implementation of three independence tests: For iid data (Berentsen et al., 2014),
for serial dependence within a time series (Lacal and Tjøstheim, 2017a), and
for serial cross-dependence between two time series (Lacal and Tjøstheim,
2017b). The first test has a different theoretical foundation than the latter
two, but the implementations are similar and differ only in the bootstrap
procedure. For the time series applications, the user must lag the series to
his/her convenience before making the \code{lg}_object and calling this
function.
}
\examples{

    # Remember to increase the number of bootstrap samplesin preactical
    # implementations.

    \dontrun{

    # Test for independence between two vectors, iid data.
    x1 <- cbind(rnorm(100), rnorm(100))
    lg_object1 <- lg_main(x1)
    test_result1 = ind_test(lg_object1,
                            bootstrap_type = "plain",
                            n_rep = 20)

    # Test for serial dependence in time series, lag 1
    data(EuStockMarkets)
    logreturns <- apply(EuStockMarkets, 2, function(x) diff(log(x)))
    x2 <- cbind(logreturns[1:100,1], logreturns[2:101, 1])
    lg_object2 <- lg_main(x2)
    test_result2 = ind_test(lg_object2,
                            bootstrap_type = "plain",
                            n_rep = 20)

    # Test for cross-dependence, lag 1
    x3 <- cbind(logreturns[1:100,1], logreturns[2:101, 2])
    lg_object3 <- lg_main(x3)
    test_result3 = ind_test(lg_object3,
                            bootstrap_type = "block",
                            n_rep = 20)
    }

}
\references{
Berentsen, Geir Drage, and Dag Tjøstheim. "Recognizing and visualizing
  departures from independence in bivariate data using local Gaussian
  correlation." Statistics and Computing 24.5 (2014): 785-801.

  Lacal, Virginia, and Dag Tjøstheim. "Local Gaussian autocorrelation and
  tests for serial independence." Journal of Time Series Analysis 38.1
  (2017a): 51-71.

  Lacal, Virginia, and Dag Tjøstheim. "Estimating and testing nonlinear local
  dependence between two time series." Journal of Business & Economic
  Statistics just-accepted (2017b).
}
