% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_table_fn.R
\name{top_table_fn}
\alias{top_table_fn}
\title{Creating the top table}
\usage{
top_table_fn(data, groups, ch_gr1, ch_gr2)
}
\arguments{
\item{data}{Normalized and missing values imputed expression dataset containing protein information}

\item{groups}{Group information about the input data}

\item{ch_gr1}{Group number of the dataset for pairwise comparison with the another group}

\item{ch_gr2}{Group number of the dataset to be compared with the chosen group}
}
\value{
Top table consists of following values

`logFC` -  Log fold change values,

`AveExpr` - Average intensity values,

`t`- t-statistic values,

`P.Value` - P-values,

`adj.P.Val` - Adjusted P-values,

`B`- B-statistic values
}
\description{
Top table can be used for identifying the pairwise differential abundance analysis of proteins in the dataset.
}
\examples{
\donttest{
top_table <- top_table_fn(knn_rlr_yeast_data, yeast_groups, 2, 1)
top_table
}
}
\seealso{
`limma::topTable`
}
