% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{chainsubset}
\alias{chainsubset}
\title{Chain subset conditions}
\usage{
chainsubset(..., out.vars)
}
\arguments{
\item{...}{Logical conditions to be chained.}

\item{out.vars}{character. Variables not in data.frame, only needed if you use variables which
are not in the frame.  If \code{out.vars} is not specified, it is assumed to match all variables
starting with a dot ('.').}
}
\value{
Expression that can be \code{eval}'ed to yield a logical subset mask.
}
\description{
Chain subset conditions
}
\details{
A set of logical conditions are chained, not and'ed. That is, each argument to
\code{chainsubset} is used as a filter to create a smaller dataset. Each subsequent
argument filters further.
For independent conditions this will be the same as and'ing them. I.e.
\code{chainsubset(x < 0 , y < 0)} will yield  the same subset as \code{(x < 0) & (y < 0)}.
However, for aggregate filters like \code{chainsubset(x < mean(y), x > mean(y))}
we first find all the observations with \code{x < mean(y)}, then among these we
find the ones with \code{x > mean(y)}.  The last \code{mean(y)} is now conditional on
\code{x < mean(y)}.
}
\note{
Some trickery is done to make this work directly in the subset argument of functions like
\code{felm()} and \code{lm()}. It might possibly fail with an error message in some situations.
If this happens, it should be done in two steps: \code{ss <- eval(chainsubset(...),data); 
lm(...,data=data, subset=ss)}. In particular, the arguments are taken literally, 
constructions like \code{function(...) {chainsubset(...)}} or \code{a <- quote(x < y); chainsubset(a)} do
not work, but \code{do.call(chainsubset,list(a))} does.
}
\examples{
set.seed(48)
N <- 10000
dat <- data.frame(y=rnorm(N), x=rnorm(N))
# It's not the same as and'ing the conditions:
felm(y ~ x,data=dat,subset=chainsubset(x < mean(y), y < 2*mean(x)))
felm(y ~ x,data=dat,subset=chainsubset(y < 2*mean(x), x < mean(y)))
felm(y ~ x,data=dat,subset=(x < mean(y)) & (y < 2*mean(x)))
lm(y ~ x, data=dat, subset=chainsubset(x < mean(y), x > mean(y)))
}
