% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lets_maplizer.R
\name{lets.maplizer}
\alias{lets.maplizer}
\title{Create a matrix summarizing species' attributes within
cells of a PresenceAbsence object}
\usage{
lets.maplizer(x, y, z, func = mean, ras = FALSE)
}
\arguments{
\item{x}{A \code{\link{PresenceAbsence}} object.}

\item{y}{Species attribute to be considered. It must be a numeric attribute.}

\item{z}{Species names in the same order as the attributes and exactly the
same as named in the \code{PresenceAbsence} object.}

\item{func}{A function to summarize the species' atribute in each cell.}

\item{ras}{If \code{TRUE} the raster object will be returned
together with the matrix.}
}
\value{
The result can be both a \code{matrix} or a \code{list} cointaining
the follow objects:

\strong{Matrix}: a \code{matrix} object with the cells' geographic
coordinates and the summarized species' attributes within them.

\strong{Raster}: The summarized species'attributed maped in a
\code{raster} object.
}
\description{
Summarize species atributes per cell in a presence-absence matrix.
}
\examples{
\dontrun{
data(PAM)
data(IUCN)
trait <- IUCN$Description_Year
resu <- lets.maplizer(PAM, trait, PAM$S, ras = TRUE)
head(resu$Matrix)
plot(resu$Raster, xlab = "Longitude", ylab = "Latitude",
main = "Mean description year per site") ; map(add = TRUE)
}
}
\author{
Bruno Vilela
}
\seealso{
\code{\link{lets.presab}}

\code{\link{lets.presab.birds}}
}

